/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.i18n.dao.jpa;

import java.io.Serializable;
import java.util.Locale;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NaturalId;
import org.jasig.portal.i18n.Message;
import org.springframework.util.Assert;

@Entity
@Table(name="UP_MESSAGE")
@SequenceGenerator(name="UP_MESSAGE_GEN", sequenceName="UP_MESSAGE_SEQ", allocationSize=5)
@TableGenerator(name="UP_MESSAGE_GEN", pkColumnValue="UP_MESSAGE", allocationSize=5)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class MessageImpl
implements Message,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_MESSAGE_GEN")
    @Column(name="ID")
    private final long id = -1L;
    @NaturalId
    @Column(name="CODE", length=128, nullable=false)
    @Index(name="IDX_MESSAGE__CODE")
    private final String code;
    @NaturalId
    @Column(name="LOCALE", length=64, nullable=false)
    @Index(name="IDX_MESSAGE__LOCALE")
    private final Locale locale;
    @Column(name="VALUE", length=1024, nullable=false)
    private String value;

    private MessageImpl() {
        this.code = null;
        this.locale = null;
    }

    MessageImpl(String code, Locale locale, String value) {
        Assert.notNull((Object)code);
        Assert.notNull((Object)locale);
        Assert.notNull((Object)value);
        this.code = code;
        this.locale = locale;
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getId() {
        return -1L;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Message) {
            return false;
        }
        Message other = (Message)obj;
        if (this.code == null ? other.getCode() != null : !this.code.equals(other.getCode())) {
            return false;
        }
        return !(this.locale == null ? other.getLocale() != null : !this.locale.equals(other.getLocale()));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("MessageImpl [id=");
        this.getClass();
        return stringBuilder.append(-1L).append(", locale=").append(this.locale).append(", code=").append(this.code).append(", value=").append(this.value).append("]").toString();
    }
}

