/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io;

import org.danann.cernunnos.AttributePhrase;
import org.danann.cernunnos.Attributes;
import org.danann.cernunnos.EntityConfig;
import org.danann.cernunnos.Formula;
import org.danann.cernunnos.Phrase;
import org.danann.cernunnos.Reagent;
import org.danann.cernunnos.ReagentType;
import org.danann.cernunnos.ReturnValue;
import org.danann.cernunnos.SimpleFormula;
import org.danann.cernunnos.SimpleReagent;
import org.danann.cernunnos.Task;
import org.danann.cernunnos.TaskRequest;
import org.danann.cernunnos.TaskResponse;
import org.dom4j.Element;
import org.jasig.portal.io.SupportedFileTypes;
import org.jasig.portal.layout.IUserLayoutStore;

public class GenerateEntityFileNameTask
implements Task {
    public static final Reagent ENTITY_ELEMENT = new SimpleReagent("ENTITY_ELEMENT", "@entity-element", ReagentType.PHRASE, Element.class, "Root element of the finished XML entity document", (Object)new AttributePhrase(Attributes.NODE));
    public static final Reagent LAYOUT_STORE = new SimpleReagent("LAYOUT_STORE", "@layout-store", ReagentType.PHRASE, IUserLayoutStore.class, "The portal's running IUserLayoutStore instance", (Object)new AttributePhrase("layoutStore"));
    private Phrase entityElement;
    private Phrase layoutStore;

    public void init(EntityConfig config) {
        this.entityElement = (Phrase)config.getValue(ENTITY_ELEMENT);
        this.layoutStore = (Phrase)config.getValue(LAYOUT_STORE);
    }

    public Formula getFormula() {
        return new SimpleFormula(GenerateEntityFileNameTask.class, new Reagent[]{ENTITY_ELEMENT, LAYOUT_STORE});
    }

    public void perform(TaskRequest req, TaskResponse res) {
        Element rootElement = (Element)this.entityElement.evaluate(req, res);
        IUserLayoutStore rdbmdls = (IUserLayoutStore)this.layoutStore.evaluate(req, res);
        SupportedFileTypes y = SupportedFileTypes.getApplicableFileType((Element)rootElement, (IUserLayoutStore)rdbmdls);
        String entityFileName = y.getSafeFileNameWithExtension(rootElement);
        ReturnValue rslt = (ReturnValue)req.getAttribute(Attributes.RETURN_VALUE);
        rslt.setValue((Object)entityFileName);
    }
}

