/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.jasig.portal.layout.IUserLayoutStore;

/*
 * Exception performing whole class analysis ignored.
 */
public enum SupportedFileTypes {
    LAYOUT/* Unavailable Anonymous Inner Class!! */,
    FRAGMENT_LAYOUT/* Unavailable Anonymous Inner Class!! */,
    PROFILE/* Unavailable Anonymous Inner Class!! */,
    PERMISSION/* Unavailable Anonymous Inner Class!! */,
    PERMISSION_SET/* Unavailable Anonymous Inner Class!! */,
    MEMBERSHIP/* Unavailable Anonymous Inner Class!! */,
    CHANNEL("channel-definition", "fname", "channel"),
    CHANNEL_TYPE("channel-type", "name"),
    GROUP/* Unavailable Anonymous Inner Class!! */,
    GROUP_MEMBERSHIP/* Unavailable Anonymous Inner Class!! */,
    USER/* Unavailable Anonymous Inner Class!! */,
    TEMPLATE_USER/* Unavailable Anonymous Inner Class!! */,
    THEME("theme", "name"),
    STRUCTURE("structure", "name"),
    ENTITY_TYPE("entity-type", "name"),
    FRAGMENT_DEFINITION("fragment-definition", "*/@name");

    private static final Pattern[] WINDOWS_INVALID_PATTERNS;
    private static Map<Pattern, String> REPLACEMENT_PAIRS;
    protected final String rootElementNodeName;
    protected final XPath documentNameXPath;
    protected final String fileExtension;
    protected final DocumentFactory fac = new DocumentFactory();

    public static SupportedFileTypes getApplicableFileType(Element e, IUserLayoutStore rdbmdls) {
        if (e == null) {
            String msg = "Argument 'e' [Element] cannot be null";
            throw new IllegalArgumentException(msg);
        }
        if (rdbmdls == null) {
            String msg = "Argument 'rdbmdls' [IUserLayoutStore] cannot be null";
            throw new IllegalArgumentException(msg);
        }
        SupportedFileTypes rslt = null;
        for (SupportedFileTypes y : SupportedFileTypes.values()) {
            if (!y.appliesTo(e, rdbmdls)) continue;
            rslt = y;
            break;
        }
        if (rslt == null) {
            String msg = "SupportedFileTypes instance not found for the specified element:  " + e.getName();
            throw new RuntimeException(msg);
        }
        return rslt;
    }

    public String getSafeFileNameWithExtension(Element e) {
        String namePart = ((Node)this.documentNameXPath.evaluate((Object)e)).getText();
        if (namePart == null) {
            String msg = "The XPath expression '" + this.documentNameXPath.getText() + "' didn't match any text in the specified element:  " + e.getName();
            throw new RuntimeException(msg);
        }
        return this.makeSafe(namePart) + "." + this.fileExtension;
    }

    private SupportedFileTypes(String rootElementNodeName, String documentNameExpression) {
        this(string, n, rootElementNodeName, documentNameExpression, rootElementNodeName);
    }

    private SupportedFileTypes(String rootElementNodeName, String documentNameExpression, String fileExtension) {
        this.rootElementNodeName = rootElementNodeName;
        this.documentNameXPath = documentNameExpression != null ? this.fac.createXPath(documentNameExpression) : null;
        this.fileExtension = fileExtension;
    }

    protected boolean appliesTo(Element e, IUserLayoutStore rdbmdls) {
        return e.getName().equals(this.rootElementNodeName);
    }

    protected final String makeSafe(String name) {
        for (Map.Entry pair : REPLACEMENT_PAIRS.entrySet()) {
            Pattern pattern = (Pattern)pair.getKey();
            Matcher matcher = pattern.matcher(name);
            name = matcher.replaceAll((String)pair.getValue());
        }
        String upperCaseName = name.toUpperCase();
        for (Pattern pattern : WINDOWS_INVALID_PATTERNS) {
            if (!pattern.matcher(upperCaseName).matches()) continue;
            name = "uP-" + name;
            break;
        }
        return name;
    }

    static {
        WINDOWS_INVALID_PATTERNS = new Pattern[]{Pattern.compile("AUX"), Pattern.compile("CLOCK\\$"), Pattern.compile("COM\\d*"), Pattern.compile("CON"), Pattern.compile("LPT\\d*"), Pattern.compile("NUL"), Pattern.compile("PRN")};
        LinkedHashMap<Pattern, String> pairs = new LinkedHashMap<Pattern, String>();
        pairs.put(Pattern.compile("/|\\\\"), ".");
        pairs.put(Pattern.compile("[~`@\\|\\s#$\\*]"), "_");
        REPLACEMENT_PAIRS = Collections.unmodifiableMap(pairs);
    }
}

