/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.jasig.portal.io.xml.IDataUpgrader;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.xml.XmlUtilities;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class XsltDataUpgrader
implements IDataUpgrader,
InitializingBean {
    private Set<PortalDataKey> portalDataKeys;
    private Resource xslResource;
    private XmlUtilities xmlUtilities;
    private Templates upgradeTemplates;

    public void setPortalDataKey(PortalDataKey portalDataKey) {
        this.portalDataKeys = Collections.singleton(portalDataKey);
    }

    public void setPortalDataKeys(Set<PortalDataKey> portalDataKeys) {
        this.portalDataKeys = ImmutableSet.copyOf(portalDataKeys);
    }

    public void setXslResource(Resource xslResource) {
        this.xslResource = xslResource;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    public void afterPropertiesSet() throws Exception {
        this.upgradeTemplates = this.xmlUtilities.getTemplates(this.xslResource);
    }

    public Set<PortalDataKey> getSourceDataTypes() {
        return this.portalDataKeys;
    }

    public boolean upgradeData(Source source, Result result) {
        Transformer transformer;
        try {
            transformer = this.upgradeTemplates.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to create new Transformer from the configured templates: " + this.xslResource, e);
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to upgrade data using XSLT transformation: " + this.xslResource, e);
        }
        return true;
    }
}

