/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.crn;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.codehaus.staxmate.dom.DOMConverter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.jasig.portal.io.xml.IDataImporter;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.threading.NoopLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.xml.FixedXMLEventStreamReader;

public abstract class AbstractDom4jImporter
implements IDataImporter<Tuple<String, Element>>,
Unmarshaller {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<PortalDataKey> dataKeys;
    private Lock lock = NoopLock.INSTANCE;

    public void setDataKeys(Set<PortalDataKey> dataKeys) {
        this.dataKeys = dataKeys;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.lock = threadSafe ? NoopLock.INSTANCE : new ReentrantLock();
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return this.dataKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(Tuple<String, Element> data) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.importDataElement(data);
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void importDataElement(Tuple<String, Element> var1);

    public Unmarshaller getUnmarshaller() {
        return this;
    }

    public boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    public Tuple<String, Element> unmarshal(Source source) throws IOException, XmlMappingException {
        Element node = this.convertToElement(source);
        return new Tuple((Object)source.getSystemId(), (Object)node);
    }

    protected Element convertToElement(Source source) {
        if (source instanceof StAXSource) {
            org.w3c.dom.Document document;
            StAXSource staxSource = (StAXSource)source;
            DOMConverter domConverter = new DOMConverter();
            try {
                XMLStreamReader xmlStreamReader = staxSource.getXMLStreamReader();
                if (xmlStreamReader == null) {
                    XMLEventReader xmlEventReader = staxSource.getXMLEventReader();
                    xmlStreamReader = new FixedXMLEventStreamReader(xmlEventReader);
                }
                document = domConverter.buildDocument(xmlStreamReader);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to parse StAX Reader into Dom4J Element", e);
            }
            DOMReader domReader = new DOMReader();
            Document dom4JDocument = domReader.read(document);
            dom4JDocument.setName(source.getSystemId());
            return dom4JDocument.getRootElement();
        }
        throw new IllegalArgumentException("Source of type " + source.getClass() + " is not supported");
    }
}

