/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.dlm;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.xpath.XPathConstants;
import org.jasig.portal.io.xml.IDataImporter;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.dlm.FragmentDefinitionImporter;
import org.jasig.portal.io.xml.dlm.FragmentDefinitionPortalDataType;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.IFragmentDefinitionDao;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.xml.XmlUtilities;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FragmentDefinitionImporter
implements IDataImporter<Tuple<String, Document>>,
Unmarshaller {
    private IFragmentDefinitionDao fragmentDefinitionDao;
    private XmlUtilities xmlUtilities;
    private XPathOperations xPathOperations;

    @Autowired
    public void setFragmentDefinitionDao(IFragmentDefinitionDao fragmentDefinitionDao) {
        this.fragmentDefinitionDao = fragmentDefinitionDao;
    }

    @Autowired
    public void setXmlUtilities(XmlUtilities xmlUtilities) {
        this.xmlUtilities = xmlUtilities;
    }

    @Autowired
    public void setxPathOperations(XPathOperations xPathOperations) {
        this.xPathOperations = xPathOperations;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(FragmentDefinitionPortalDataType.IMPORT_31_DATA_KEY);
    }

    @Transactional
    public void importData(Tuple<String, Document> data) {
        Document resultDoc = (Document)data.second;
        Element fragmentDefElement = (Element)this.xPathOperations.evaluate("//*[local-name() = 'fragment']", (Object)resultDoc, XPathConstants.NODE);
        if (fragmentDefElement == null) {
            throw new IllegalArgumentException("Could not find required dlm:fragment element in fragment-definition file");
        }
        String fragmentName = fragmentDefElement.getAttribute("name");
        FragmentDefinition fragmentDefinition = this.fragmentDefinitionDao.getFragmentDefinition(fragmentName);
        if (fragmentDefinition == null) {
            fragmentDefinition = new FragmentDefinition(fragmentDefElement);
        }
        fragmentDefinition.loadFromEelement(fragmentDefElement);
        this.fragmentDefinitionDao.updateFragmentDefinition(fragmentDefinition);
    }

    public Unmarshaller getUnmarshaller() {
        return this;
    }

    public boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(Source source) throws IOException, XmlMappingException {
        Transformer identityTransformer;
        if (source instanceof StAXSource) {
            source = this.fixStAXSource((StAXSource)source);
        }
        try {
            identityTransformer = this.xmlUtilities.getIdentityTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to create identity Transformer", e);
        }
        DOMResult domResult = new DOMResult();
        try {
            identityTransformer.transform(source, domResult);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to transform " + source + " into Document", e);
        }
        Document resultDoc = (Document)domResult.getNode();
        return new Tuple((Object)source.getSystemId(), (Object)resultDoc);
    }

    protected Source fixStAXSource(StAXSource staxSource) {
        VersionCachingXMLEventStreamReader streamReader;
        XMLStreamReader xmlStreamReader = staxSource.getXMLStreamReader();
        if (xmlStreamReader != null) {
            return staxSource;
        }
        XMLEventReader xmlEventReader = staxSource.getXMLEventReader();
        try {
            streamReader = new VersionCachingXMLEventStreamReader(xmlEventReader);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XMLStreamReader from XMLEventReader", e);
        }
        return new StAXSource((XMLStreamReader)streamReader);
    }
}

