/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.eventaggr;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jasig.portal.events.aggr.AcademicTermDetail;
import org.jasig.portal.events.aggr.AggregatedGroupConfig;
import org.jasig.portal.events.aggr.AggregatedIntervalConfig;
import org.jasig.portal.events.aggr.AggregationInterval;
import org.jasig.portal.events.aggr.EventDateTimeUtils;
import org.jasig.portal.events.aggr.IPortalEventAggregator;
import org.jasig.portal.events.aggr.QuarterDetail;
import org.jasig.portal.events.aggr.dao.IEventAggregationManagementDao;
import org.jasig.portal.events.aggr.dao.jpa.QuarterDetailImpl;
import org.jasig.portal.events.aggr.groups.AggregatedGroupLookupDao;
import org.jasig.portal.events.aggr.groups.AggregatedGroupMapping;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.eventaggr.EventAggregationConfigurationPortalDataType;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregatedDimensionConfigComparator;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregatedGroupConfig;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregatedGroupMapping;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregatedGroupMappingComparator;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregatedIntervalConfig;
import org.jasig.portal.io.xml.eventaggr.ExternalAggregationInterval;
import org.jasig.portal.io.xml.eventaggr.ExternalEventAggregationConfiguration;
import org.jasig.portal.io.xml.eventaggr.ExternalQuarterDetail;
import org.jasig.portal.io.xml.eventaggr.ExternalQuarterDetailComparator;
import org.jasig.portal.io.xml.eventaggr.ExternalTermDetail;
import org.jasig.portal.io.xml.eventaggr.ExternalTermDetailComparator;
import org.jasig.portal.utils.EnumNameComparator;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.joda.time.DateMidnight;
import org.joda.time.MonthDay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EventAggregationConfigurationImporterExporter
extends AbstractJaxbDataHandler<ExternalEventAggregationConfiguration> {
    private static final String SINGLE_DATA_ID = "CONFIG";
    private EventAggregationConfigurationPortalDataType eventAggregationDataType;
    private IEventAggregationManagementDao aggregationManagementDao;
    private AggregatedGroupLookupDao aggregatedGroupLookupDao;

    @Autowired
    public void setAggregatedGroupLookupDao(AggregatedGroupLookupDao aggregatedGroupLookupDao) {
        this.aggregatedGroupLookupDao = aggregatedGroupLookupDao;
    }

    @Autowired
    public void setEventAggregationDataType(EventAggregationConfigurationPortalDataType eventAggregationDataType) {
        this.eventAggregationDataType = eventAggregationDataType;
    }

    @Autowired
    public void setAggregationManagementDao(IEventAggregationManagementDao aggregationManagementDao) {
        this.aggregationManagementDao = aggregationManagementDao;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(EventAggregationConfigurationPortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.eventAggregationDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        return ImmutableSet.of((Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional(value="aggrEventsTransactionManager")
    public void importData(ExternalEventAggregationConfiguration data) {
        HashSet oldAggregatedIntervalConfigs = new HashSet(this.aggregationManagementDao.getAggregatedIntervalConfigs());
        for (ExternalAggregatedIntervalConfig extAggregatedIntervalConfig : data.getAggregatedIntervalConfigs()) {
            String aggregatorTypeName = extAggregatedIntervalConfig.getAggregatorType();
            Class aggregatorType = this.getAggregatorType(aggregatorTypeName);
            AggregatedIntervalConfig aggregatedIntervalConfig = this.aggregationManagementDao.getAggregatedIntervalConfig(aggregatorType);
            if (aggregatedIntervalConfig == null) {
                aggregatedIntervalConfig = this.aggregationManagementDao.createAggregatedIntervalConfig(aggregatorType);
            }
            oldAggregatedIntervalConfigs.remove(aggregatedIntervalConfig);
            Set excluded = aggregatedIntervalConfig.getExcluded();
            excluded.clear();
            for (ExternalAggregationInterval extInterval : extAggregatedIntervalConfig.getExcludes()) {
                excluded.add(this.convert(extInterval));
            }
            Set included = aggregatedIntervalConfig.getIncluded();
            included.clear();
            for (ExternalAggregationInterval extInterval : extAggregatedIntervalConfig.getIncludes()) {
                included.add(this.convert(extInterval));
            }
            this.aggregationManagementDao.updateAggregatedIntervalConfig(aggregatedIntervalConfig);
        }
        for (AggregatedIntervalConfig aggregatedIntervalConfig : oldAggregatedIntervalConfigs) {
            this.aggregationManagementDao.deleteAggregatedIntervalConfig(aggregatedIntervalConfig);
        }
        HashSet oldAggregatedGroupConfigs = new HashSet(this.aggregationManagementDao.getAggregatedGroupConfigs());
        for (ExternalAggregatedGroupConfig extAggregatedGroupConfig : data.getAggregatedGroupConfigs()) {
            String aggregatorTypeName = extAggregatedGroupConfig.getAggregatorType();
            Class aggregatorType = this.getAggregatorType(aggregatorTypeName);
            AggregatedGroupConfig aggregatedGroupConfig = this.aggregationManagementDao.getAggregatedGroupConfig(aggregatorType);
            if (aggregatedGroupConfig == null) {
                aggregatedGroupConfig = this.aggregationManagementDao.createAggregatedGroupConfig(aggregatorType);
            }
            oldAggregatedGroupConfigs.remove(aggregatedGroupConfig);
            Set excluded = aggregatedGroupConfig.getExcluded();
            excluded.clear();
            for (ExternalAggregatedGroupMapping extGroup : extAggregatedGroupConfig.getExcludes()) {
                excluded.add(this.convert(extGroup));
            }
            Set included = aggregatedGroupConfig.getIncluded();
            included.clear();
            for (ExternalAggregatedGroupMapping extGroup : extAggregatedGroupConfig.getIncludes()) {
                included.add(this.convert(extGroup));
            }
            this.aggregationManagementDao.updateAggregatedGroupConfig(aggregatedGroupConfig);
        }
        for (AggregatedGroupConfig aggregatedGroupConfig : oldAggregatedGroupConfigs) {
            this.aggregationManagementDao.deleteAggregatedGroupConfig(aggregatedGroupConfig);
        }
        List extQuarterDetails = data.getQuarterDetails();
        List quarterDetails = !extQuarterDetails.isEmpty() ? this.convertQuarterDetail(extQuarterDetails) : EventDateTimeUtils.createStandardQuarters();
        this.aggregationManagementDao.setQuarterDetails(quarterDetails);
        List academicTerms = Lists.transform((List)data.getTermDetails(), (Function)new /* Unavailable Anonymous Inner Class!! */);
        this.aggregationManagementDao.setAcademicTermDetails(academicTerms);
    }

    protected List<QuarterDetail> convertQuarterDetail(List<ExternalQuarterDetail> externalQuarterDetails) {
        ArrayList<QuarterDetail> quarterDetails = new ArrayList<QuarterDetail>(4);
        for (ExternalQuarterDetail externalQuarterDetail : externalQuarterDetails) {
            quarterDetails.add((QuarterDetail)new QuarterDetailImpl(MonthDay.parse((String)externalQuarterDetail.getStart()), MonthDay.parse((String)externalQuarterDetail.getEnd()), externalQuarterDetail.getId()));
        }
        return quarterDetails;
    }

    protected AggregatedGroupMapping convert(ExternalAggregatedGroupMapping externalAggregatedGroupMapping) {
        return this.aggregatedGroupLookupDao.getGroupMapping(externalAggregatedGroupMapping.getGroupService(), externalAggregatedGroupMapping.getGroupName());
    }

    protected AggregationInterval convert(ExternalAggregationInterval externalAggregationInterval) {
        return AggregationInterval.valueOf((String)externalAggregationInterval.name());
    }

    protected Class<? extends IPortalEventAggregator> getAggregatorType(String aggregatorTypeName) {
        Class<?> aggregatorType;
        try {
            aggregatorType = Class.forName(aggregatorTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Specified aggregator type name " + aggregatorTypeName + " could not be resolved to a Class", e);
        }
        if (!IPortalEventAggregator.class.isAssignableFrom(aggregatorType)) {
            throw new IllegalArgumentException("Specified aggregator type " + aggregatorType.getName() + " is not an instance of " + IPortalEventAggregator.class.getName());
        }
        return aggregatorType;
    }

    public ExternalEventAggregationConfiguration exportData(String id) {
        ExternalEventAggregationConfiguration externalData = new ExternalEventAggregationConfiguration();
        List aggregatedIntervalConfigs = externalData.getAggregatedIntervalConfigs();
        for (AggregatedIntervalConfig aggregatedIntervalConfig : this.aggregationManagementDao.getAggregatedIntervalConfigs()) {
            ExternalAggregatedIntervalConfig externalIntervalConfig = new ExternalAggregatedIntervalConfig();
            externalIntervalConfig.setAggregatorType(aggregatedIntervalConfig.getAggregatorType().getName());
            List extIncludes = externalIntervalConfig.getIncludes();
            for (AggregationInterval interval : aggregatedIntervalConfig.getIncluded()) {
                extIncludes.add(this.convert(interval));
            }
            Collections.sort(extIncludes, EnumNameComparator.INSTANCE);
            List extExcludes = externalIntervalConfig.getExcludes();
            for (AggregationInterval interval : aggregatedIntervalConfig.getExcluded()) {
                extExcludes.add(this.convert(interval));
            }
            Collections.sort(extExcludes, EnumNameComparator.INSTANCE);
            aggregatedIntervalConfigs.add(externalIntervalConfig);
        }
        Collections.sort(aggregatedIntervalConfigs, ExternalAggregatedDimensionConfigComparator.INSTANCE);
        List aggregatedGroupConfigs = externalData.getAggregatedGroupConfigs();
        for (AggregatedGroupConfig aggregatedGroupConfig : this.aggregationManagementDao.getAggregatedGroupConfigs()) {
            ExternalAggregatedGroupConfig externalGroupConfig = new ExternalAggregatedGroupConfig();
            externalGroupConfig.setAggregatorType(aggregatedGroupConfig.getAggregatorType().getName());
            List extIncludes = externalGroupConfig.getIncludes();
            for (AggregatedGroupMapping Group : aggregatedGroupConfig.getIncluded()) {
                extIncludes.add(this.convert(Group));
            }
            Collections.sort(extIncludes, ExternalAggregatedGroupMappingComparator.INSTANCE);
            List extExcludes = externalGroupConfig.getExcludes();
            for (AggregatedGroupMapping Group : aggregatedGroupConfig.getExcluded()) {
                extExcludes.add(this.convert(Group));
            }
            Collections.sort(extExcludes, ExternalAggregatedGroupMappingComparator.INSTANCE);
            aggregatedGroupConfigs.add(externalGroupConfig);
        }
        Collections.sort(aggregatedGroupConfigs, ExternalAggregatedDimensionConfigComparator.INSTANCE);
        List externalTermDetails = externalData.getTermDetails();
        for (AcademicTermDetail academicTermDetail : this.aggregationManagementDao.getAcademicTermDetails()) {
            ExternalTermDetail externalTermDetail = new ExternalTermDetail();
            externalTermDetail.setName(academicTermDetail.getTermName());
            externalTermDetail.setStart((Calendar)((DateMidnight)academicTermDetail.getStart()).toGregorianCalendar());
            externalTermDetail.setEnd((Calendar)((DateMidnight)academicTermDetail.getEnd()).toGregorianCalendar());
            externalTermDetails.add(externalTermDetail);
        }
        Collections.sort(externalTermDetails, ExternalTermDetailComparator.INSTANCE);
        List quarterDetails = externalData.getQuarterDetails();
        for (QuarterDetail quarterDetail : this.aggregationManagementDao.getQuartersDetails()) {
            ExternalQuarterDetail externalQuarterDetail = new ExternalQuarterDetail();
            externalQuarterDetail.setId(quarterDetail.getQuarterId());
            externalQuarterDetail.setStart(((MonthDay)quarterDetail.getStart()).toString());
            externalQuarterDetail.setEnd(((MonthDay)quarterDetail.getEnd()).toString());
            quarterDetails.add(externalQuarterDetail);
        }
        Collections.sort(quarterDetails, ExternalQuarterDetailComparator.INSTANCE);
        return externalData;
    }

    protected ExternalAggregationInterval convert(AggregationInterval aggregationInterval) {
        return ExternalAggregationInterval.valueOf((String)aggregationInterval.name());
    }

    protected ExternalAggregatedGroupMapping convert(AggregatedGroupMapping aggregatedGroupMapping) {
        ExternalAggregatedGroupMapping externalAggregatedGroupMapping = new ExternalAggregatedGroupMapping();
        externalAggregatedGroupMapping.setGroupService(aggregatedGroupMapping.getGroupService());
        externalAggregatedGroupMapping.setGroupName(aggregatedGroupMapping.getGroupName());
        return externalAggregatedGroupMapping;
    }

    public String getFileName(ExternalEventAggregationConfiguration data) {
        return SafeFilenameUtils.makeSafeFilename((String)"default");
    }

    @Transactional(value="aggrEventsTransactionManager")
    public ExternalEventAggregationConfiguration deleteData(String id) {
        ExternalEventAggregationConfiguration data = this.exportData(id);
        for (AggregatedIntervalConfig aggregatedIntervalConfig : this.aggregationManagementDao.getAggregatedIntervalConfigs()) {
            this.aggregationManagementDao.deleteAggregatedIntervalConfig(aggregatedIntervalConfig);
        }
        for (AggregatedGroupConfig aggregatedGroupConfig : this.aggregationManagementDao.getAggregatedGroupConfigs()) {
            this.aggregationManagementDao.deleteAggregatedGroupConfig(aggregatedGroupConfig);
        }
        this.aggregationManagementDao.setAcademicTermDetails(Collections.emptyList());
        this.aggregationManagementDao.setQuarterDetails(EventDateTimeUtils.createStandardQuarters());
        return data;
    }
}

