/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.layout;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.dom4j.Element;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.UserProfile;
import org.jasig.portal.io.xml.crn.AbstractDom4jExporter;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.BrokenSecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.Tuple;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;

public class LayoutExporter
extends AbstractDom4jExporter {
    private final Cache<Tuple<String, String>, UserProfile> layoutCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<Tuple<String, String>, Document> profileCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private IUserLayoutStore userLayoutStore;
    private IUserIdentityStore userIdentityStore;

    @Autowired
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element exportDataElement(String userName) {
        Integer userId = this.userIdentityStore.getPortalUserId(userName);
        if (userId == null) {
            this.logger.warn("No user " + userName + " found, no layout will be exported");
            return null;
        }
        PersonImpl person = new PersonImpl();
        person.setUserName(userName);
        person.setID(userId.intValue());
        person.setSecurityContext((ISecurityContext)new BrokenSecurityContext());
        try {
            Element layoutElement;
            this.userLayoutStore.setProfileImportExportCache(this.layoutCache);
            this.userLayoutStore.setLayoutImportExportCache(this.profileCache);
            IUserProfile userProfile = this.userLayoutStore.getUserProfileByFname((IPerson)person, "default");
            Element element = layoutElement = this.userLayoutStore.exportLayout((IPerson)person, userProfile);
            return element;
        }
        finally {
            this.userLayoutStore.setProfileImportExportCache(null);
            this.userLayoutStore.setLayoutImportExportCache(null);
        }
    }
}

