/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.layout;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.io.xml.AbstractPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.layout.FragmentLayoutPortalDataType;
import org.jasig.portal.xml.StaxUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class LayoutPortalDataType
extends AbstractPortalDataType {
    public static final QName LEGACY_LAYOUT_QNAME = new QName("layout");
    public static final PortalDataKey IMPORT_32_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_QNAME, "classpath://org/jasig/portal/io/import-layout_v3-2.crn", null);
    @Deprecated
    public static final PortalDataKey IMPORT_30_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_QNAME, "classpath://org/jasig/portal/io/import-layout_v3-0.crn", null);
    @Deprecated
    public static final PortalDataKey IMPORT_26_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_QNAME, "classpath://org/jasig/portal/io/import-layout_v2-6.crn", null);
    @Deprecated
    public static final QName LEGACY_LAYOUT_DEFAULT_USER_QNAME = new QName("default-user-layout");
    @Deprecated
    public static final PortalDataKey IMPORT_32_DEFAULT_USER_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_DEFAULT_USER_QNAME, "classpath://org/jasig/portal/io/import-layout_v3-2.crn", null);
    @Deprecated
    public static final PortalDataKey IMPORT_30_DEFAULT_USER_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_DEFAULT_USER_QNAME, "classpath://org/jasig/portal/io/import-layout_v3-0.crn", null);
    @Deprecated
    public static final PortalDataKey IMPORT_26_DEFAULT_USER_DATA_KEY = new PortalDataKey(LEGACY_LAYOUT_DEFAULT_USER_QNAME, "classpath://org/jasig/portal/io/import-layout_v2-6.crn", null);
    private static final List<PortalDataKey> PORTAL_DATA_KEYS = Arrays.asList(IMPORT_26_DEFAULT_USER_DATA_KEY, IMPORT_30_DEFAULT_USER_DATA_KEY, IMPORT_32_DEFAULT_USER_DATA_KEY, IMPORT_26_DATA_KEY, IMPORT_30_DATA_KEY, IMPORT_32_DATA_KEY);
    private IUserIdentityStore userIdentityStore;

    public LayoutPortalDataType() {
        super(LEGACY_LAYOUT_QNAME);
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    public List<PortalDataKey> getDataKeyImportOrder() {
        return PORTAL_DATA_KEYS;
    }

    public String getTitleCode() {
        return "Layout";
    }

    public String getDescriptionCode() {
        return "User Layout";
    }

    protected PortalDataKey postProcessSinglePortalDataKey(String systemId, PortalDataKey portalDataKey, XMLEventReader reader) {
        if (systemId.endsWith(".fragment-layout.xml") || systemId.endsWith(".fragment-layout")) {
            return this.convertToFragmentKey(portalDataKey);
        }
        if (IMPORT_26_DATA_KEY.equals((Object)portalDataKey) || IMPORT_30_DATA_KEY.equals((Object)portalDataKey)) {
            StartElement startElement = StaxUtils.getRootElement((XMLEventReader)reader);
            Attribute usernameAttr = startElement.getAttributeByName(new QName("username"));
            if (usernameAttr != null) {
                String username = usernameAttr.getValue();
                if (this.userIdentityStore.isDefaultUser(username)) {
                    return this.convertToDefaultUserKey(portalDataKey);
                }
            } else {
                this.logger.warn("No username attribute on StartElement for {}", (Object)systemId);
            }
        }
        return portalDataKey;
    }

    private PortalDataKey convertToDefaultUserKey(PortalDataKey portalDataKey) {
        if (IMPORT_32_DATA_KEY.equals((Object)portalDataKey)) {
            return IMPORT_32_DEFAULT_USER_DATA_KEY;
        }
        if (IMPORT_30_DATA_KEY.equals((Object)portalDataKey)) {
            return IMPORT_30_DEFAULT_USER_DATA_KEY;
        }
        if (IMPORT_26_DATA_KEY.equals((Object)portalDataKey)) {
            return IMPORT_26_DEFAULT_USER_DATA_KEY;
        }
        throw new IllegalArgumentException("Portal Data Key " + portalDataKey + " has no default user equivalent");
    }

    private PortalDataKey convertToFragmentKey(PortalDataKey portalDataKey) {
        if (IMPORT_32_DATA_KEY.equals((Object)portalDataKey)) {
            return FragmentLayoutPortalDataType.IMPORT_32_DATA_KEY;
        }
        if (IMPORT_30_DATA_KEY.equals((Object)portalDataKey)) {
            return FragmentLayoutPortalDataType.IMPORT_30_DATA_KEY;
        }
        if (IMPORT_26_DATA_KEY.equals((Object)portalDataKey)) {
            return FragmentLayoutPortalDataType.IMPORT_26_DATA_KEY;
        }
        throw new IllegalArgumentException("Portal Data Key " + portalDataKey + " has no fragment layout equivalent");
    }
}

