/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.permission;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.permission.ExternalActivity;
import org.jasig.portal.io.xml.permission.ExternalActivityFnameComparator;
import org.jasig.portal.io.xml.permission.ExternalPermissionOwner;
import org.jasig.portal.io.xml.permission.PermissionOwnerPortalDataType;
import org.jasig.portal.permission.IPermissionActivity;
import org.jasig.portal.permission.IPermissionOwner;
import org.jasig.portal.permission.dao.IPermissionOwnerDao;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class PermissionOwnerImporterExporter
extends AbstractJaxbDataHandler<ExternalPermissionOwner> {
    private PermissionOwnerPortalDataType portalDataType;
    private IPermissionOwnerDao permissionOwnerDao;

    @Autowired
    public void setPortalDataType(PermissionOwnerPortalDataType portalDataType) {
        this.portalDataType = portalDataType;
    }

    @Autowired
    public void setPermissionOwnerDao(IPermissionOwnerDao permissionOwnerDao) {
        this.permissionOwnerDao = permissionOwnerDao;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(PermissionOwnerPortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.portalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        List permissionOwners = this.permissionOwnerDao.getAllPermissionOwners();
        return Lists.transform((List)permissionOwners, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void importData(ExternalPermissionOwner externalPermissionOwner) {
        String name = externalPermissionOwner.getName();
        String fname = externalPermissionOwner.getFname();
        IPermissionOwner permissionOwner = this.permissionOwnerDao.getOrCreatePermissionOwner(name, fname);
        String desc = externalPermissionOwner.getDesc();
        permissionOwner.setDescription(desc);
        for (ExternalActivity externalActivity : externalPermissionOwner.getActivities()) {
            String activityName = externalActivity.getName();
            String activityFname = externalActivity.getFname();
            String targetProvider = externalActivity.getTargetProvider();
            IPermissionActivity permissionActivity = this.permissionOwnerDao.getOrCreatePermissionActivity(permissionOwner, activityName, activityFname, targetProvider);
            String activityDesc = externalActivity.getDesc();
            permissionActivity.setDescription(activityDesc);
        }
        this.permissionOwnerDao.saveOwner(permissionOwner);
    }

    public ExternalPermissionOwner exportData(String fname) {
        IPermissionOwner permissionOwner = this.permissionOwnerDao.getPermissionOwner(fname);
        return this.convert(permissionOwner);
    }

    public String getFileName(ExternalPermissionOwner data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getFname());
    }

    public ExternalPermissionOwner deleteData(String id) {
        throw new UnsupportedOperationException();
    }

    protected ExternalPermissionOwner convert(IPermissionOwner permissionOwner) {
        if (permissionOwner == null) {
            return null;
        }
        ExternalPermissionOwner externalPermissionOwner = new ExternalPermissionOwner();
        externalPermissionOwner.setName(permissionOwner.getName());
        externalPermissionOwner.setFname(permissionOwner.getFname());
        externalPermissionOwner.setDesc(permissionOwner.getDescription());
        List externalActivities = externalPermissionOwner.getActivities();
        Set activities = permissionOwner.getActivities();
        for (IPermissionActivity permissionActivity : activities) {
            ExternalActivity externalActivity = new ExternalActivity();
            externalActivity.setName(permissionActivity.getName());
            externalActivity.setFname(permissionActivity.getFname());
            externalActivity.setDesc(permissionActivity.getDescription());
            externalActivity.setTargetProvider(permissionActivity.getTargetProviderKey());
            externalActivities.add(externalActivity);
        }
        Collections.sort(externalActivities, ExternalActivityFnameComparator.INSTANCE);
        return externalPermissionOwner;
    }
}

