/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.portlet;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.channel.IPortletPublishingService;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IEntityNameFinder;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.portlet.ExternalPortletDefinition;
import org.jasig.portal.io.xml.portlet.ExternalPortletParameter;
import org.jasig.portal.io.xml.portlet.ExternalPortletParameterNameComparator;
import org.jasig.portal.io.xml.portlet.ExternalPortletPreference;
import org.jasig.portal.io.xml.portlet.ExternalPortletPreferenceNameComparator;
import org.jasig.portal.io.xml.portlet.PortletPortalDataType;
import org.jasig.portal.portlet.dao.IPortletDefinitionDao;
import org.jasig.portal.portlet.dao.jpa.PortletDefinitionParameterImpl;
import org.jasig.portal.portlet.dao.jpa.PortletPreferenceImpl;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionId;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.IPortletDescriptorKey;
import org.jasig.portal.portlet.om.IPortletPreference;
import org.jasig.portal.portlet.om.IPortletType;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlet.registry.IPortletCategoryRegistry;
import org.jasig.portal.portlet.registry.IPortletTypeRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPermission;
import org.jasig.portal.security.IPermissionManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IUpdatingPermissionManager;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.services.EntityNameFinderService;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.jasig.portal.xml.PortletDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class PortletDefinitionImporterExporter
extends AbstractJaxbDataHandler<ExternalPortletDefinition>
implements IPortletPublishingService {
    private PortletPortalDataType portletPortalDataType;
    private IPortletTypeRegistry portletTypeRegistry;
    private IPortletDefinitionDao portletDefinitionDao;
    private IPortletCategoryRegistry portletCategoryRegistry;
    private boolean errorOnChannel = true;
    private final Object groupUpdateLock = new Object();

    @Value(value="${org.jasig.portal.io.errorOnChannel}")
    public void setErrorOnChannel(boolean errorOnChannel) {
        this.errorOnChannel = errorOnChannel;
    }

    @Autowired
    public void setPortletPortalDataType(PortletPortalDataType portletPortalDataType) {
        this.portletPortalDataType = portletPortalDataType;
    }

    @Autowired
    public void setPortletTypeRegistry(IPortletTypeRegistry portletTypeRegistry) {
        this.portletTypeRegistry = portletTypeRegistry;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionDao portletDefinitionRegistry) {
        this.portletDefinitionDao = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortletCategoryRegistry(IPortletCategoryRegistry portletCategoryRegistry) {
        this.portletCategoryRegistry = portletCategoryRegistry;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(PortletPortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.portletPortalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        return this.portletDefinitionDao.getPortletDefinitions();
    }

    @Transactional
    public void importData(ExternalPortletDefinition portletRep) {
        BigInteger resourceTimeout;
        BigInteger renderTimeout;
        BigInteger eventTimeout;
        BigInteger actionTimeout;
        PortletDescriptor portletDescriptor = portletRep.getPortletDescriptor();
        Boolean isFramework = portletDescriptor.isIsFramework();
        if (isFramework != null && isFramework.booleanValue() && "UPGRADED_CHANNEL_IS_NOT_A_PORTLET".equals(portletDescriptor.getPortletName())) {
            if (this.errorOnChannel) {
                throw new IllegalArgumentException(portletRep.getFname() + " is not a portlet. It was likely an IChannel from a previous version of uPortal and cannot be imported.");
            }
            this.logger.warn(portletRep.getFname() + " is not a portlet. It was likely an IChannel from a previous version of uPortal and will not be imported.");
            return;
        }
        IPortletType portletType = this.portletTypeRegistry.getPortletType(portletRep.getType());
        if (portletType == null) {
            throw new IllegalArgumentException("No portlet type registered for: " + portletRep.getType());
        }
        ArrayList<PortletCategory> categories = new ArrayList<PortletCategory>();
        for (String categoryName : portletRep.getCategories()) {
            EntityIdentifier[] cats = GroupService.searchForGroups((String)categoryName, (int)1, IPortletDefinition.class);
            PortletCategory category = null;
            category = cats != null && cats.length > 0 ? this.portletCategoryRegistry.getPortletCategory(cats[0].getKey()) : this.portletCategoryRegistry.getPortletCategory(categoryName);
            if (category == null) {
                throw new IllegalArgumentException("No category '" + categoryName + "' found when importing porltet: " + portletRep.getFname());
            }
            categories.add(category);
        }
        ArrayList<IEntityGroup> groups = new ArrayList<IEntityGroup>();
        for (String groupName : portletRep.getGroups()) {
            EntityIdentifier[] gs = GroupService.searchForGroups((String)groupName, (int)1, IPerson.class);
            IEntityGroup group = gs != null && gs.length > 0 ? GroupService.findGroup((String)gs[0].getKey()) : GroupService.findGroup((String)groupName);
            if (group == null) {
                throw new IllegalArgumentException("No group '" + groupName + "' found when importing porltet: " + portletRep.getFname());
            }
            groups.add(group);
        }
        String fname = portletRep.getFname();
        IPortletDefinition def = this.portletDefinitionDao.getPortletDefinitionByFname(fname);
        if (def == null) {
            def = this.portletDefinitionDao.createPortletDefinition(portletType, fname, portletRep.getName(), portletRep.getTitle(), portletDescriptor.getWebAppName(), portletDescriptor.getPortletName(), isFramework != null ? isFramework : false);
        } else {
            IPortletDescriptorKey portletDescriptorKey = def.getPortletDescriptorKey();
            portletDescriptorKey.setPortletName(portletDescriptor.getPortletName());
            if (isFramework != null && isFramework.booleanValue()) {
                portletDescriptorKey.setFrameworkPortlet(true);
                portletDescriptorKey.setWebAppName(null);
            } else {
                portletDescriptorKey.setFrameworkPortlet(false);
                portletDescriptorKey.setWebAppName(portletDescriptor.getWebAppName());
            }
        }
        def.setName(portletRep.getName());
        def.setTitle(portletRep.getTitle());
        def.setDescription(portletRep.getDesc());
        BigInteger timeout = portletRep.getTimeout();
        if (timeout != null) {
            def.setTimeout(timeout.intValue());
        }
        if ((actionTimeout = portletRep.getActionTimeout()) != null) {
            def.setActionTimeout(Integer.valueOf(actionTimeout.intValue()));
        }
        if ((eventTimeout = portletRep.getEventTimeout()) != null) {
            def.setEventTimeout(Integer.valueOf(eventTimeout.intValue()));
        }
        if ((renderTimeout = portletRep.getRenderTimeout()) != null) {
            def.setRenderTimeout(Integer.valueOf(renderTimeout.intValue()));
        }
        if ((resourceTimeout = portletRep.getResourceTimeout()) != null) {
            def.setResourceTimeout(Integer.valueOf(resourceTimeout.intValue()));
        }
        def.setType(portletType);
        Date now = new Date();
        IPerson systemUser = PersonFactory.createSystemPerson();
        def.setApprovalDate(now);
        def.setApproverId(systemUser.getID());
        def.setPublishDate(now);
        def.setPublisherId(systemUser.getID());
        LinkedHashSet<PortletDefinitionParameterImpl> parameters = new LinkedHashSet<PortletDefinitionParameterImpl>();
        for (ExternalPortletParameter param : portletRep.getParameters()) {
            parameters.add(new PortletDefinitionParameterImpl(param.getName(), param.getValue()));
        }
        def.setParameters(parameters);
        ArrayList<PortletPreferenceImpl> preferenceList = new ArrayList<PortletPreferenceImpl>();
        for (ExternalPortletPreference pref : portletRep.getPortletPreferences()) {
            List valueList = pref.getValues();
            String[] values = valueList.toArray(new String[valueList.size()]);
            Boolean readOnly = pref.isReadOnly();
            preferenceList.add(new PortletPreferenceImpl(pref.getName(), readOnly != null ? readOnly : false, values));
        }
        def.setPortletPreferences(preferenceList);
        this.savePortletDefinition(def, PersonFactory.createSystemPerson(), categories, groups);
    }

    @Transactional
    public ExternalPortletDefinition deleteData(String fname) {
        IPortletDefinition def = this.portletDefinitionDao.getPortletDefinitionByFname(fname);
        if (null == def) {
            return null;
        }
        ExternalPortletDefinition result = this.convert(def);
        this.portletDefinitionDao.deletePortletDefinition(def);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPortletDefinition savePortletDefinition(IPortletDefinition definition, IPerson publisher, List<PortletCategory> categories, List<IGroupMember> groupMembers) {
        IPortletDefinitionId portletDefinitionId = definition.getPortletDefinitionId();
        boolean newChannel = portletDefinitionId == null;
        definition = this.portletDefinitionDao.updatePortletDefinition(definition);
        definition = this.portletDefinitionDao.getPortletDefinitionByFname(definition.getFName());
        String defId = portletDefinitionId.getStringId();
        IEntity portletDefEntity = GroupService.getEntity((String)defId, IPortletDefinition.class);
        Object object = this.groupUpdateLock;
        synchronized (object) {
            if (!newChannel) {
                Iterator iter = portletDefEntity.getAllContainingGroups();
                while (iter.hasNext()) {
                    IEntityGroup group = (IEntityGroup)iter.next();
                    group.removeMember((IGroupMember)portletDefEntity);
                    group.update();
                }
            }
            for (PortletCategory category : categories) {
                IEntityGroup categoryGroup = GroupService.findGroup((String)category.getId());
                categoryGroup.addMember((IGroupMember)portletDefEntity);
                categoryGroup.updateMembers();
            }
            AuthorizationService authService = AuthorizationService.instance();
            String target = "PORTLET_ID." + defId;
            IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager("UP_PORTLET_SUBSCRIBE");
            ArrayList<IPermission> permissions = new ArrayList<IPermission>(groupMembers.size());
            for (IGroupMember member : groupMembers) {
                IAuthorizationPrincipal authPrincipal = authService.newPrincipal(member);
                IPermission permission = upm.newPermission(authPrincipal);
                permission.setType("GRANT");
                permission.setActivity("SUBSCRIBE");
                permission.setTarget(target);
                permissions.add(permission);
            }
            if (!newChannel) {
                IPermission[] oldPermissions = upm.getPermissions("SUBSCRIBE", target);
                upm.removePermissions(oldPermissions);
            }
            upm.addPermissions(permissions.toArray(new IPermission[permissions.size()]));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Portlet " + defId + " has been " + (newChannel ? "published" : "modified") + ".");
        }
        return definition;
    }

    @Transactional
    public void removePortletDefinition(IPortletDefinition portletDefinition, IPerson person) {
        IPortletDefinition portletDef = this.portletDefinitionDao.getPortletDefinition(portletDefinition.getPortletDefinitionId());
        String portletDefinitionId = portletDefinition.getPortletDefinitionId().getStringId();
        IEntity channelDefEntity = GroupService.getEntity((String)portletDefinitionId, IPortletDefinition.class);
        Iterator iter = channelDefEntity.getAllContainingGroups();
        while (iter.hasNext()) {
            IEntityGroup group = (IEntityGroup)iter.next();
            group.removeMember((IGroupMember)channelDefEntity);
            group.update();
        }
        AuthorizationService authService = AuthorizationService.instance();
        String target = "PORTLET_ID." + portletDefinitionId;
        IUpdatingPermissionManager upm = authService.newUpdatingPermissionManager("UP_PORTLET_SUBSCRIBE");
        IPermission[] oldPermissions = upm.getPermissions("SUBSCRIBE", target);
        upm.removePermissions(oldPermissions);
        this.portletDefinitionDao.deletePortletDefinition(portletDef);
    }

    public ExternalPortletDefinition exportData(String fname) {
        IPortletDefinition def = this.portletDefinitionDao.getPortletDefinitionByFname(fname);
        if (def == null) {
            return null;
        }
        return this.convert(def);
    }

    public String getFileName(ExternalPortletDefinition data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getFname());
    }

    protected BigInteger convertToBigInteger(Integer i) {
        if (i == null) {
            return null;
        }
        return BigInteger.valueOf(i.intValue());
    }

    protected ExternalPortletDefinition convert(IPortletDefinition def) {
        IAuthorizationPrincipal[] principals;
        ExternalPortletDefinition rep = new ExternalPortletDefinition();
        rep.setFname(def.getFName());
        rep.setDesc(def.getDescription());
        rep.setName(def.getName());
        rep.setTimeout(BigInteger.valueOf(def.getTimeout()));
        rep.setActionTimeout(this.convertToBigInteger(def.getActionTimeout()));
        rep.setEventTimeout(this.convertToBigInteger(def.getEventTimeout()));
        rep.setRenderTimeout(this.convertToBigInteger(def.getRenderTimeout()));
        rep.setResourceTimeout(this.convertToBigInteger(def.getResourceTimeout()));
        rep.setTitle(def.getTitle());
        rep.setType(def.getType().getName());
        PortletDescriptor portletDescriptor = new PortletDescriptor();
        IPortletDescriptorKey portletDescriptorKey = def.getPortletDescriptorKey();
        if (portletDescriptorKey.isFrameworkPortlet()) {
            portletDescriptor.setIsFramework(Boolean.valueOf(true));
        } else {
            portletDescriptor.setWebAppName(portletDescriptorKey.getWebAppName());
        }
        portletDescriptor.setPortletName(portletDescriptorKey.getPortletName());
        rep.setPortletDescriptor(portletDescriptor);
        List parameterList = rep.getParameters();
        for (IPortletDefinitionParameter param : def.getParameters()) {
            ExternalPortletParameter externalPortletParameter = new ExternalPortletParameter();
            externalPortletParameter.setName(param.getName());
            externalPortletParameter.setDescription(param.getDescription());
            externalPortletParameter.setValue(param.getValue());
            parameterList.add(externalPortletParameter);
        }
        Collections.sort(parameterList, ExternalPortletParameterNameComparator.INSTANCE);
        List portletPreferenceList = rep.getPortletPreferences();
        for (IPortletPreference pref : def.getPortletPreferences()) {
            ExternalPortletPreference externalPortletPreference = new ExternalPortletPreference();
            externalPortletPreference.setName(pref.getName());
            externalPortletPreference.setReadOnly(Boolean.valueOf(pref.isReadOnly()));
            List value = externalPortletPreference.getValues();
            value.addAll(Arrays.asList(pref.getValues()));
            portletPreferenceList.add(externalPortletPreference);
        }
        Collections.sort(portletPreferenceList, ExternalPortletPreferenceNameComparator.INSTANCE);
        List categoryList = rep.getCategories();
        IGroupMember gm = GroupService.getGroupMember((String)def.getPortletDefinitionId().getStringId(), IPortletDefinition.class);
        Iterator categories = GroupService.getCompositeGroupService().findContainingGroups(gm);
        while (categories.hasNext()) {
            IEntityGroup category = (IEntityGroup)categories.next();
            categoryList.add(category.getName());
        }
        Collections.sort(categoryList);
        List groupList = rep.getGroups();
        List userList = rep.getUsers();
        AuthorizationService authService = AuthorizationService.instance();
        IPermissionManager pm = authService.newPermissionManager("UP_PORTLET_SUBSCRIBE");
        for (IAuthorizationPrincipal principal : principals = pm.getAuthorizedPrincipals("SUBSCRIBE", "PORTLET_ID." + def.getPortletDefinitionId().getStringId())) {
            IGroupMember member = authService.getGroupMember(principal);
            if (member.isGroup()) {
                EntityNameFinderService entityNameFinderService = EntityNameFinderService.instance();
                IEntityNameFinder nameFinder = entityNameFinderService.getNameFinder(member.getType());
                try {
                    groupList.add(nameFinder.getName(member.getKey()));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not find group name for entity: " + member.getKey(), e);
                }
            }
            userList.add(member.getKey());
        }
        Collections.sort(groupList);
        Collections.sort(userList);
        return rep;
    }
}

