/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.io.xml.subscribedfragment;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.fragment.subscribe.dao.IUserFragmentSubscriptionDao;
import org.jasig.portal.io.xml.AbstractJaxbDataHandler;
import org.jasig.portal.io.xml.IPortalData;
import org.jasig.portal.io.xml.IPortalDataType;
import org.jasig.portal.io.xml.PortalDataKey;
import org.jasig.portal.io.xml.subscribedfragment.ExternalSubscribedFragments;
import org.jasig.portal.io.xml.subscribedfragment.SubscribedFragmentPortalDataType;
import org.jasig.portal.io.xml.subscribedfragment.SubscribedFragmentType;
import org.jasig.portal.io.xml.subscribedfragment.SubscribedFragmentTypeComparator;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.ISecurityContext;
import org.jasig.portal.security.provider.BrokenSecurityContext;
import org.jasig.portal.security.provider.PersonImpl;
import org.jasig.portal.utils.SafeFilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

public class SubscribedFragmentImporterExporter
extends AbstractJaxbDataHandler<ExternalSubscribedFragments> {
    private SubscribedFragmentPortalDataType subscribedFragmentPortalDataType;
    private IUserFragmentSubscriptionDao userFragmentSubscriptionDao;
    private IUserIdentityStore userIdentityStore;
    private boolean errorOnMissingUser = true;

    @Autowired
    public void setSubscribedFragmentPortalDataType(SubscribedFragmentPortalDataType subscribedFragmentPortalDataType) {
        this.subscribedFragmentPortalDataType = subscribedFragmentPortalDataType;
    }

    @Autowired
    public void setUserFragmentSubscriptionDao(IUserFragmentSubscriptionDao userFragmentSubscriptionDao) {
        this.userFragmentSubscriptionDao = userFragmentSubscriptionDao;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    @Value(value="${org.jasig.portal.io.layout.errorOnMissingUser:true}")
    public void setErrorOnMissingUser(boolean errorOnMissingUser) {
        this.errorOnMissingUser = errorOnMissingUser;
    }

    public Set<PortalDataKey> getImportDataKeys() {
        return Collections.singleton(SubscribedFragmentPortalDataType.IMPORT_40_DATA_KEY);
    }

    public IPortalDataType getPortalDataType() {
        return this.subscribedFragmentPortalDataType;
    }

    public Iterable<? extends IPortalData> getPortalData() {
        List allUsersWithActiveSubscriptions = this.userFragmentSubscriptionDao.getAllUsersWithActiveSubscriptions();
        return Collections2.transform((Collection)allUsersWithActiveSubscriptions, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void importData(ExternalSubscribedFragments data) {
        String username = data.getUsername();
        IPerson person = this.getPerson(username, true);
        for (SubscribedFragmentType subscribedFragmentType : data.getSubscribedFragments()) {
            String fragmentOwner = subscribedFragmentType.getFragmentOwner();
            IPerson fragmentPerson = this.getPerson(fragmentOwner, false);
            if (fragmentPerson == null) {
                throw new IllegalArgumentException("No fragmentOwner " + fragmentOwner + " exists to subscribe to, be sure to import all fragment owners first");
            }
            IUserFragmentSubscription userFragmentSubscription = this.userFragmentSubscriptionDao.getUserFragmentInfo(person, fragmentPerson);
            if (userFragmentSubscription != null) continue;
            this.userFragmentSubscriptionDao.createUserFragmentInfo(person, fragmentPerson);
        }
    }

    private IPerson getPerson(String username, boolean create) {
        int userId;
        PersonImpl person = new PersonImpl();
        person.setUserName(username);
        try {
            userId = this.userIdentityStore.getPortalUID((IPerson)person);
        }
        catch (Throwable t) {
            if (!create || this.errorOnMissingUser) {
                throw new RuntimeException("Unrecognized user " + person.getUserName() + "; you must import users before their layouts.", t);
            }
            if (create) {
                userId = this.userIdentityStore.getPortalUID((IPerson)person, true);
            }
            return null;
        }
        person.setID(userId);
        person.setSecurityContext((ISecurityContext)new BrokenSecurityContext());
        return person;
    }

    public ExternalSubscribedFragments exportData(String id) {
        IPerson person = this.getPerson(id, false);
        if (person == null) {
            return null;
        }
        return this.exportInternal(person);
    }

    private ExternalSubscribedFragments exportInternal(IPerson person) {
        ExternalSubscribedFragments data = new ExternalSubscribedFragments();
        data.setUsername(person.getUserName());
        List subscribedFragments = data.getSubscribedFragments();
        for (IUserFragmentSubscription userFragmentSubscription : this.userFragmentSubscriptionDao.getUserFragmentInfo(person)) {
            if (!userFragmentSubscription.isActive()) continue;
            SubscribedFragmentType subscribedFragmentType = new SubscribedFragmentType();
            subscribedFragmentType.setFragmentOwner(userFragmentSubscription.getFragmentOwner());
            subscribedFragments.add(subscribedFragmentType);
        }
        if (subscribedFragments.isEmpty()) {
            return null;
        }
        Collections.sort(subscribedFragments, SubscribedFragmentTypeComparator.INSTANCE);
        return data;
    }

    public String getFileName(ExternalSubscribedFragments data) {
        return SafeFilenameUtils.makeSafeFilename((String)data.getUsername());
    }

    @Transactional
    public ExternalSubscribedFragments deleteData(String id) {
        IPerson person = this.getPerson(id, false);
        if (person == null) {
            return null;
        }
        ExternalSubscribedFragments data = this.exportInternal(person);
        for (IUserFragmentSubscription userFragmentSubscription : this.userFragmentSubscriptionDao.getUserFragmentInfo(person)) {
            this.userFragmentSubscriptionDao.deleteUserFragmentInfo(userFragmentSubscription);
        }
        return data;
    }
}

