/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import org.jasig.portal.jgroups.auth.AuthDao;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;
import org.springframework.security.core.token.Sha512DigestUtils;

public class HashedDaoAuthToken
extends AuthToken {
    private static volatile AuthDao authDao;
    private String authValue;

    public static void setAuthDao(AuthDao authDao) {
        if (HashedDaoAuthToken.authDao != null) {
            LogFactory.getLog(HashedDaoAuthToken.class).warn("A AuthDao was already set. " + HashedDaoAuthToken.authDao + " will be replaced with " + authDao);
        }
        HashedDaoAuthToken.authDao = authDao;
    }

    public String getAuthValue() {
        String av = this.authValue;
        if (av == null) {
            if (authDao == null) {
                throw new IllegalStateException("An AuthDao needs to be injected for the HashedDaoAuthToken to function");
            }
            String authToken = authDao.getAuthToken(this.getName());
            if (authToken != null) {
                this.authValue = av = Sha512DigestUtils.shaHex((String)authToken);
            }
        }
        return av;
    }

    public int size() {
        return Util.size((String)this.getAuthValue());
    }

    public String getName() {
        return HashedDaoAuthToken.class.getName();
    }

    public boolean authenticate(AuthToken token, Message msg) {
        if (token != null && token instanceof HashedDaoAuthToken) {
            HashedDaoAuthToken serverToken = (HashedDaoAuthToken)token;
            String localAuthValue = this.getAuthValue();
            String messageAuthValue = serverToken.getAuthValue();
            if (localAuthValue != null && messageAuthValue != null && localAuthValue.equalsIgnoreCase(messageAuthValue)) {
                this.log.debug("HashedDaoAuthToken match");
                return true;
            }
            return false;
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn("Invalid AuthToken instance - wrong type or null: " + token);
        }
        return false;
    }

    public void writeTo(DataOutput out) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("HashedDaoAuthToken writeTo()");
        }
        Util.writeString((String)this.getAuthValue(), (DataOutput)out);
    }

    public void readFrom(DataInput in) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("HashedDaoAuthToken readFrom()");
        }
        this.authValue = Util.readString((DataInput)in);
    }
}

