/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jgroups.auth;

import java.util.Collection;
import java.util.Collections;
import org.hibernate.exception.ConstraintViolationException;
import org.jasig.portal.jgroups.auth.AuthDao;
import org.jasig.portal.jgroups.auth.HashedDaoAuthToken;
import org.jasig.portal.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class JdbcAuthDao
implements AuthDao,
InitializingBean {
    private static final String PRM_SERVICE_NAME = "serviceName";
    private static final String PRM_RANDOM_TOKEN = "randomToken";
    private static final String INSERT_SQL = "INSERT INTO UP_JGROUPS_AUTH (SERVICE_NAME, RANDOM_TOKEN) values (:serviceName, :randomToken)";
    private static final String SELECT_SQL = "SELECT RANDOM_TOKEN FROM UP_JGROUPS_AUTH WHERE SERVICE_NAME=:serviceName";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int authTokenLength = 1000;
    private JdbcOperations jdbcOperations;
    private NamedParameterJdbcOperations namedParameterJdbcOperations;
    private volatile boolean ready = false;

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        this.namedParameterJdbcOperations = new NamedParameterJdbcTemplate(this.jdbcOperations);
    }

    @Value(value="${org.jasig.portal.jgroups.auth.token_length:1000}")
    public void setAuthTokenLength(int authTokenLength) {
        this.authTokenLength = authTokenLength;
    }

    public void afterPropertiesSet() throws Exception {
        HashedDaoAuthToken.setAuthDao((AuthDao)this);
    }

    public String getAuthToken(String serviceName) {
        if (!this.isReady()) {
            return null;
        }
        for (int count = 0; count < 10; ++count) {
            String token = (String)DataAccessUtils.singleResult((Collection)this.namedParameterJdbcOperations.queryForList(SELECT_SQL, Collections.singletonMap(PRM_SERVICE_NAME, serviceName), String.class));
            if (token != null) {
                return token;
            }
            this.createToken(serviceName);
        }
        this.logger.warn("Failed to get/create auth token for {} after 10 tries", (Object)serviceName);
        return null;
    }

    protected void createToken(String serviceName) {
        try {
            this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ConstraintViolationException e) {
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            // empty catch block
        }
    }

    protected boolean isReady() {
        boolean r = this.ready;
        if (!r && (r = JdbcUtils.doesTableExist((JdbcOperations)this.jdbcOperations, (String)"UP_JGROUPS_AUTH"))) {
            this.ready = r;
        }
        return r;
    }

    static /* synthetic */ int access$000(JdbcAuthDao x0) {
        return x0.authTokenLength;
    }

    static /* synthetic */ NamedParameterJdbcOperations access$100(JdbcAuthDao x0) {
        return x0.namedParameterJdbcOperations;
    }
}

