/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jgroups.protocols;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jasig.portal.jgroups.protocols.DAO_PING;
import org.jasig.portal.jgroups.protocols.PingDao;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.Discovery;

public class DAO_PING
extends Discovery {
    private static volatile PingDao pingDao;
    @Property(description="Interval (in milliseconds) at which the own Address is written. 0 disables it.")
    protected long interval = 60000L;
    private Future<?> writer_future;

    public static void setPingDao(PingDao pingDao) {
        if (DAO_PING.pingDao != null) {
            LogFactory.getLog(DAO_PING.class).warn("A PingDao was already set. " + DAO_PING.pingDao + " will be replaced with " + pingDao);
        }
        DAO_PING.pingDao = pingDao;
    }

    public boolean sendDiscoveryRequestsInParallel() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public void start() throws Exception {
        super.start();
        if (this.interval > 0L) {
            this.writer_future = this.timer.scheduleWithFixedDelay((Runnable)new WriterTask(this), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        Future wf = this.writer_future;
        if (wf != null) {
            wf.cancel(false);
            this.writer_future = null;
        }
        super.stop();
    }

    public void destroy() {
        super.destroy();
        pingDao = null;
    }

    public Collection<PhysicalAddress> fetchClusterMembers(String clusterName) {
        if (pingDao == null) {
            this.log.info("No PingDao set, returning empty set for current cluster members");
            return Collections.emptyList();
        }
        Map existing_mbrs = pingDao.getAddresses(clusterName);
        this.getAndSavePhysicalAddress(clusterName);
        return existing_mbrs.values();
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return retval;
    }

    protected void getAndSavePhysicalAddress(String clusterName) {
        if (pingDao == null) {
            this.log.info("No PingDao set, skiping save of physical address for cluster " + clusterName);
            return;
        }
        PhysicalAddress physicalAddr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        pingDao.addAddress(clusterName, this.local_addr, physicalAddr);
    }

    protected void handleView(View view) {
        boolean is_coordinator;
        if (pingDao == null) {
            this.log.info("No PingDao set, ignoring view change.");
            return;
        }
        List mbrs = view.getMembers();
        boolean bl = is_coordinator = !mbrs.isEmpty() && ((Address)mbrs.iterator().next()).equals(this.local_addr);
        if (is_coordinator) {
            pingDao.purgeOtherAddresses(this.group_addr, (Collection)mbrs);
        }
    }

    static /* synthetic */ String access$000(DAO_PING x0) {
        return x0.group_addr;
    }

    static {
        ClassConfigurator.addProtocol((short)600, DAO_PING.class);
    }
}

