/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jgroups.protocols;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.jasig.portal.jgroups.protocols.DAO_PING;
import org.jasig.portal.jgroups.protocols.PingDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.logging.ConditionalExceptionLogger;
import org.jasig.portal.logging.ConditionalExceptionLoggerImpl;
import org.jasig.portal.utils.JdbcUtils;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class JdbcPingDao
implements PingDao,
InitializingBean {
    private static final String CLASS_PRM_SUFFIX = "Class";
    private static final String DATA_PRM_SUFFIX = "Data";
    private static final String PRM_CLUSTER_NAME = "clusterName";
    private static final String PRM_MEMBER_ADDRESS = "memberAddress";
    private static final String PRM_MEMBER_ADDRESS_CLASS = "memberAddressClass";
    private static final String PRM_MEMBER_ADDRESS_DATA = "memberAddressData";
    private static final String PRM_PHYSICAL_ADDRESS = "physicalAddress";
    private static final String PRM_PHYSICAL_ADDRESS_CLASS = "physicalAddressClass";
    private static final String PRM_PHYSICAL_ADDRESS_DATA = "physicalAddressData";
    private static final String UPDATE_SQL = "UPDATE UP_JGROUPS_PING SET PHYSICAL_ADDRESS=:physicalAddress, PHYSICAL_ADDRESS_CLASS=:physicalAddressClass, PHYSICAL_ADDRESS_DATA=:physicalAddressData WHERE CLUSTER_NAME=:clusterName AND MEMBER_ADDRESS_CLASS=:memberAddressClass AND MEMBER_ADDRESS_DATA=:memberAddressData";
    private static final String INSERT_SQL = "INSERT INTO UP_JGROUPS_PING (CLUSTER_NAME, MEMBER_ADDRESS, MEMBER_ADDRESS_CLASS, MEMBER_ADDRESS_DATA, PHYSICAL_ADDRESS, PHYSICAL_ADDRESS_CLASS, PHYSICAL_ADDRESS_DATA) values (:clusterName, :memberAddress, :memberAddressClass, :memberAddressData, :physicalAddress, :physicalAddressClass, :physicalAddressData)";
    private static final String SELECT_CLUSTER_SQL = "SELECT MEMBER_ADDRESS_CLASS, MEMBER_ADDRESS_DATA, PHYSICAL_ADDRESS_CLASS, PHYSICAL_ADDRESS_DATA FROM UP_JGROUPS_PING WHERE CLUSTER_NAME=:clusterName";
    private static final String DELETE_SQL = "DELETE FROM UP_JGROUPS_PING WHERE CLUSTER_NAME=:clusterName";
    protected final ConditionalExceptionLogger logger = new ConditionalExceptionLoggerImpl(LoggerFactory.getLogger(this.getClass()));
    private JdbcOperations jdbcOperations;
    private NamedParameterJdbcOperations namedParameterJdbcOperations;
    private volatile boolean ready = false;

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
        this.namedParameterJdbcOperations = new NamedParameterJdbcTemplate(this.jdbcOperations);
    }

    public void afterPropertiesSet() throws Exception {
        DAO_PING.setPingDao((PingDao)this);
    }

    @BasePortalJpaDao.PortalTransactional
    public void addAddress(String clusterName, Address address, PhysicalAddress physicalAddress) {
        if (!this.isReady()) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            paramMap.put(PRM_CLUSTER_NAME, clusterName);
            this.setStreamableParam(paramMap, PRM_MEMBER_ADDRESS, (Streamable)address);
            this.setStreamableParam(paramMap, PRM_PHYSICAL_ADDRESS, (Streamable)physicalAddress);
            int rowCount = this.namedParameterJdbcOperations.update(UPDATE_SQL, paramMap);
            if (rowCount == 0) {
                this.namedParameterJdbcOperations.update(INSERT_SQL, paramMap);
                this.logger.debug("Inserted cluster address: " + paramMap);
            } else {
                this.logger.debug("Updated cluster address: " + paramMap);
            }
        }
        catch (Exception e) {
            this.logger.warnDebug("Failed to store cluster address: " + paramMap, (Throwable)e);
        }
    }

    public Map<Address, PhysicalAddress> getAddresses(String clusterName) {
        if (!this.isReady()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(PRM_CLUSTER_NAME, clusterName);
        return (Map)this.namedParameterJdbcOperations.query(SELECT_CLUSTER_SQL, paramMap, (ResultSetExtractor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BasePortalJpaDao.PortalTransactional
    public void purgeOtherAddresses(String clusterName, Collection<Address> includedAddresses) {
        if (!this.isReady()) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(PRM_CLUSTER_NAME, clusterName);
        StringBuilder deleteSqlBuilder = new StringBuilder(DELETE_SQL);
        for (Address address : includedAddresses) {
            String paramPrefix = PRM_MEMBER_ADDRESS + paramMap.size();
            deleteSqlBuilder.append(" AND (").append("MEMBER_ADDRESS_CLASS").append(" <> :").append(paramPrefix).append(CLASS_PRM_SUFFIX).append(" OR ").append("MEMBER_ADDRESS_DATA").append(" <> :").append(paramPrefix).append(DATA_PRM_SUFFIX).append(")");
            this.setStreamableParam(paramMap, paramPrefix, (Streamable)address);
        }
        try {
            int purged = this.namedParameterJdbcOperations.update(deleteSqlBuilder.toString(), paramMap);
            this.logger.debug("Purged {} addresses from '{}' cluster while retaining: {}", new Object[]{purged, clusterName, includedAddresses});
        }
        catch (DataIntegrityViolationException e) {
            this.logger.warnDebug("Failed to purge old addresses for cluster '" + clusterName + "'", (Throwable)e);
        }
    }

    protected boolean isReady() {
        boolean r = this.ready;
        if (!r && (r = JdbcUtils.doesTableExist((JdbcOperations)this.jdbcOperations, (String)"UP_JGROUPS_PING"))) {
            this.ready = r;
        }
        return r;
    }

    protected <T extends Streamable> T getStreamableParam(ResultSet rs, String columnPrefix) throws SQLException {
        Class<?> cl;
        String className = rs.getString(columnPrefix + "_CLASS");
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find class '" + className + "'", e);
        }
        String streamableData = rs.getString(columnPrefix + "_DATA");
        try {
            byte[] streamableBytes = Base64.decodeBase64((String)streamableData);
            return (T)Util.streamableFromByteBuffer(cl, (byte[])streamableBytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert base64 string '" + streamableData + "' back into '" + cl + "'", e);
        }
    }

    protected void setStreamableParam(Map<String, Object> paramMap, String paramPrefix, Streamable s) {
        paramMap.put(paramPrefix + CLASS_PRM_SUFFIX, s.getClass().getName());
        try {
            byte[] streamableBytes = Util.streamableToByteBuffer((Streamable)s);
            String streamableData = Base64.encodeBase64String((byte[])streamableBytes);
            paramMap.put(paramPrefix + DATA_PRM_SUFFIX, streamableData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert '" + s + "' into a base64 string for persistence", e);
        }
        paramMap.put(paramPrefix, s.toString());
    }
}

