/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jpa;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.aopalliance.aop.Advice;
import org.jasig.portal.jpa.EventingLocalContainerEntityManagerFactoryBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class EventingLocalContainerEntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean
implements ApplicationEventPublisherAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final AtomicLong EVENT_ID = new AtomicLong();
    private final AtomicBoolean contextReady = new AtomicBoolean(false);
    private ApplicationEventPublisher applicationEventPublisher;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.contextReady.set(true);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        String persistenceUnitName = this.getPersistenceUnitName();
        EntityManagerFactory nativeEntityManagerFactory = super.createNativeEntityManagerFactory();
        ProxyFactory proxyFactory = new ProxyFactory((Object)nativeEntityManagerFactory);
        proxyFactory.addAdvice((Advice)new EventingEntityMangerFactoryInterceptor(this.applicationEventPublisher, this.contextReady, persistenceUnitName));
        return (EntityManagerFactory)proxyFactory.getProxy();
    }

    static /* synthetic */ AtomicLong access$000() {
        return EVENT_ID;
    }
}

