/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jpa;

import org.jasig.portal.jpa.BaseAggrEventsJpaDao;
import org.jasig.portal.jpa.IVersionedDatabaseUpdateHelper;
import org.jasig.portal.tools.dbloader.ISchemaExport;
import org.jasig.portal.version.VersionUtils;
import org.jasig.portal.version.om.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class Version404AggrEventsDatabaseUpdateHelper
implements IVersionedDatabaseUpdateHelper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Version version = VersionUtils.parseVersion((String)"4.0.4");
    private ISchemaExport schemaExport;

    @Autowired
    @Qualifier(value="AggrEventsDb")
    public void setSchemaExport(ISchemaExport schemaExport) {
        this.schemaExport = schemaExport;
    }

    public String getDatabaseName() {
        return "AggrEventsDb";
    }

    public Version getVersion() {
        return this.version;
    }

    @BaseAggrEventsJpaDao.AggrEventsTransactional
    public void preUpdate() {
        this.logger.info("Dropping aggregate event tables for upgrade from " + this.getVersion());
        this.schemaExport.drop(true, null, true);
        this.logger.info("Creating aggregate event tables for upgrade from " + this.getVersion());
        this.schemaExport.create(true, null, true);
        this.logger.warn("IMPORTANT: You must import your event aggregation configuration again!\n\tex: ant data-import -Dfile=/path/to/uportal/uportal-war/src/main/data/default_entities/event-aggregation/default.event-aggregation.xml");
    }

    public void postUpdate() {
    }
}

