/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.jpa.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.jasig.portal.jpa.AbstractEntityManagerEvent;
import org.jasig.portal.jpa.EntityManagerClosingEvent;
import org.jasig.portal.jpa.EntityManagerCreatedEvent;
import org.jasig.portal.jpa.cache.EntityManagerCache;
import org.jasig.portal.utils.cache.CacheEntryTag;
import org.jasig.portal.utils.cache.CacheKey;
import org.jasig.portal.utils.cache.SimpleCacheEntryTag;
import org.jasig.portal.utils.cache.TaggedCacheEntryPurger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class EntityManagerCacheImpl
implements ApplicationListener<AbstractEntityManagerEvent>,
DisposableBean,
EntityManagerCache {
    private static final String CACHE_TAG = "entityManagerId";
    private static final String CACHE_KEY_SOURCE = EntityManagerCacheImpl.class.getName();
    private static final ThreadLocal<Map<String, Deque<String>>> CURRENT_ENTITY_MANAGER_SESSIONS = new ThreadLocal();
    private static final LoadingCache<String, AtomicInteger> OPEN_EM_COUNTER = CacheBuilder.newBuilder().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Ehcache contentCache;
    private TaggedCacheEntryPurger taggedCacheEntryPurger;

    @Autowired
    @Qualifier(value="org.jasig.portal.jpa.cache.EntityManagerCache")
    public void setContentCache(Ehcache contentCache) {
        this.contentCache = contentCache;
    }

    @Autowired
    public void setTaggedCacheEntryPurger(TaggedCacheEntryPurger taggedCacheEntryPurger) {
        this.taggedCacheEntryPurger = taggedCacheEntryPurger;
    }

    public void put(String persistenceUnitName, Serializable key, Object value) {
        Map currentEntityManagers = (Map)CURRENT_ENTITY_MANAGER_SESSIONS.get();
        if (currentEntityManagers == null) {
            this.logger.error("There is no currentEntityManagers Map in the ThreadLocal, no EntityManager scoped caching will be done. persistenceUnitName=" + persistenceUnitName + ", key=" + key, new Throwable());
            return;
        }
        Deque entityManagerIds = (Deque)currentEntityManagers.get(persistenceUnitName);
        if (entityManagerIds == null || entityManagerIds.isEmpty()) {
            this.logger.error("Cannot access cache for persistent unit " + persistenceUnitName + ", it has no active EntityManager, no EntityManager scoped caching will be done. key=" + key, new Throwable());
            return;
        }
        String entityManagerId = (String)entityManagerIds.getFirst();
        SimpleCacheEntryTag entityManagerIdTag = new SimpleCacheEntryTag(CACHE_TAG, (Object)entityManagerId);
        CacheKey cacheKey = CacheKey.buildTagged((String)CACHE_KEY_SOURCE, (CacheEntryTag)entityManagerIdTag, (Serializable[])new Serializable[]{entityManagerId, key});
        this.contentCache.put(new Element((Object)cacheKey, value));
    }

    public <T> T get(String persistenceUnitName, Serializable key) {
        Map currentEntityManagers = (Map)CURRENT_ENTITY_MANAGER_SESSIONS.get();
        if (currentEntityManagers == null) {
            this.logger.error("There is no currentEntityManagers Map in the ThreadLocal, no EntityManager scoped caching will be done. persistenceUnitName=" + persistenceUnitName + ", key=" + key, new Throwable());
            return null;
        }
        Deque entityManagerIds = (Deque)currentEntityManagers.get(persistenceUnitName);
        if (entityManagerIds == null || entityManagerIds.isEmpty()) {
            this.logger.error("Cannot access cache for persistent unit " + persistenceUnitName + ", it has no active EntityManager, no EntityManager scoped caching will be done. key=" + key, new Throwable());
            return null;
        }
        String entityManagerId = (String)entityManagerIds.getFirst();
        SimpleCacheEntryTag entityManagerIdTag = new SimpleCacheEntryTag(CACHE_TAG, (Object)entityManagerId);
        CacheKey cacheKey = CacheKey.buildTagged((String)CACHE_KEY_SOURCE, (CacheEntryTag)entityManagerIdTag, (Serializable[])new Serializable[]{entityManagerId, key});
        Element element = this.contentCache.get((Serializable)cacheKey);
        if (element == null) {
            return null;
        }
        return (T)element.getObjectValue();
    }

    public void onApplicationEvent(AbstractEntityManagerEvent event) {
        String persistenceUnitName = event.getPersistenceUnitName();
        AtomicInteger counter = (AtomicInteger)OPEN_EM_COUNTER.getUnchecked((Object)persistenceUnitName);
        String entityManagerId = event.getEntityManagerId();
        if (event instanceof EntityManagerCreatedEvent) {
            LinkedList<String> entityManagerIds;
            HashMap<String, LinkedList<String>> currentEntityManagers;
            int count = counter.incrementAndGet();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("CREATE " + count + " - " + entityManagerId + " " + Thread.currentThread().getName());
            }
            if ((currentEntityManagers = (HashMap<String, LinkedList<String>>)CURRENT_ENTITY_MANAGER_SESSIONS.get()) == null) {
                currentEntityManagers = new HashMap<String, LinkedList<String>>();
                CURRENT_ENTITY_MANAGER_SESSIONS.set(currentEntityManagers);
            }
            if ((entityManagerIds = (LinkedList<String>)currentEntityManagers.get(persistenceUnitName)) == null) {
                entityManagerIds = new LinkedList<String>();
                currentEntityManagers.put(persistenceUnitName, entityManagerIds);
            }
            entityManagerIds.offerFirst(entityManagerId);
        } else if (event instanceof EntityManagerClosingEvent) {
            String currentEntityManagerId;
            Deque entityManagerIds;
            int count = counter.decrementAndGet();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("CLOSE  " + count + " - " + entityManagerId + " " + Thread.currentThread().getName());
            }
            this.taggedCacheEntryPurger.purgeCacheEntries((CacheEntryTag)new SimpleCacheEntryTag(CACHE_TAG, (Object)entityManagerId));
            Map currentEntityManagers = (Map)CURRENT_ENTITY_MANAGER_SESSIONS.get();
            if (currentEntityManagers == null || currentEntityManagers.isEmpty()) {
                this.logger.error("Closing " + entityManagerId + " but there is no currentEntityManagers Map for this Thread", new Throwable());
            }
            if ((entityManagerIds = (Deque)currentEntityManagers.get(persistenceUnitName)) == null || entityManagerIds.isEmpty()) {
                this.logger.error("Closing " + entityManagerId + " but there is no entityManagerIds Deque for this Thread", new Throwable());
            }
            if (!(currentEntityManagerId = (String)entityManagerIds.getFirst()).equals(entityManagerId)) {
                this.logger.error("Closing " + entityManagerId + " but the current EntityManagerId is " + currentEntityManagerId, new Throwable());
            }
            entityManagerIds.removeFirst();
            if (entityManagerIds.isEmpty()) {
                currentEntityManagers.remove(persistenceUnitName);
            }
            if (currentEntityManagers.isEmpty()) {
                CURRENT_ENTITY_MANAGER_SESSIONS.remove();
            }
        }
    }

    public void destroy() throws Exception {
        for (Map.Entry entityManagerCountEntry : OPEN_EM_COUNTER.asMap().entrySet()) {
            AtomicInteger counter = (AtomicInteger)entityManagerCountEntry.getValue();
            int count = counter.get();
            if (count <= 0) continue;
            String persistenceUnit = (String)entityManagerCountEntry.getKey();
            this.logger.error("PersistenceUnit {} has {} EntityManagers that were opened but never closed", (Object)persistenceUnit, (Object)count);
        }
    }
}

