/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.json.rendering;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.portal.character.stream.events.CharacterDataEvent;
import org.jasig.portal.character.stream.events.CharacterEvent;
import org.jasig.portal.character.stream.events.CharacterEventTypes;
import org.jasig.portal.events.IPortletExecutionEventFactory;
import org.jasig.portal.rendering.CharacterPipelineComponent;
import org.jasig.portal.rendering.IPortalRenderingPipeline;
import org.jasig.portal.rendering.PipelineEventReader;
import org.jasig.portal.rendering.RenderingPipelineConfigurationException;
import org.jasig.portal.url.IPortalRequestInfo;
import org.jasig.portal.url.IUrlSyntaxProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JsonLayoutRenderingPipeline
implements IPortalRenderingPipeline {
    public static final String CHARACTER_SET = "UTF-8";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CharacterPipelineComponent pipeline;
    private IPortletExecutionEventFactory portalEventFactory;
    private IUrlSyntaxProvider urlSyntaxProvider;

    @Autowired
    public void setUrlSyntaxProvider(IUrlSyntaxProvider urlSyntaxProvider) {
        this.urlSyntaxProvider = urlSyntaxProvider;
    }

    @Autowired
    public void setPortalEventFactory(IPortletExecutionEventFactory portalEventFactory) {
        this.portalEventFactory = portalEventFactory;
    }

    public void setPipeline(CharacterPipelineComponent pipeline) {
        this.pipeline = pipeline;
    }

    public void renderState(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setHeader("pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache, max-age=0, must-revalidate");
        res.setDateHeader("Expires", 0L);
        long startTime = System.nanoTime();
        PipelineEventReader pipelineEventReader = this.pipeline.getEventReader(req, res);
        String contentType = "application/json; charset=UTF-8";
        res.setContentType("application/json; charset=UTF-8");
        PrintWriter writer = res.getWriter();
        for (CharacterEvent event : pipelineEventReader) {
            if (CharacterEventTypes.CHARACTER != event.getEventType()) {
                throw new RenderingPipelineConfigurationException("Only " + CharacterEventTypes.CHARACTER + " events are supported in the top level renderer. " + event.getEventType() + " is not supported.");
            }
            String data = ((CharacterDataEvent)event).getData();
            writer.print(data);
            writer.flush();
            res.flushBuffer();
        }
        long executionTime = System.nanoTime() - startTime;
        IPortalRequestInfo portalRequestInfo = this.urlSyntaxProvider.getPortalRequestInfo(req);
        this.portalEventFactory.publishPortalRenderEvent(req, (Object)this, req.getPathInfo(), executionTime, portalRequestInfo);
    }
}

