/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import org.jasig.portal.layout.INodeIdResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PortletTabIdResolver
implements INodeIdResolver {
    private final String layoutNodeId;

    public PortletTabIdResolver(String layoutNodeId) {
        this.layoutNodeId = layoutNodeId;
    }

    public String traverseDocument(Document document) {
        for (Node root = document.getFirstChild(); root != null; root = root.getNextSibling()) {
            for (Node rootFolder = root.getFirstChild(); rootFolder != null; rootFolder = rootFolder.getNextSibling()) {
                for (Node tab = rootFolder.getFirstChild(); tab != null; tab = tab.getNextSibling()) {
                    if (!this.containsElmentWithId(tab, this.layoutNodeId)) continue;
                    return ((Element)tab).getAttribute("ID");
                }
            }
        }
        return null;
    }

    private boolean containsElmentWithId(Node node, String id) {
        String nodeName = node.getNodeName();
        if ("channel".equals(nodeName) || "folder".equals(nodeName)) {
            Element e = (Element)node;
            if (id.equals(e.getAttribute("ID"))) {
                return true;
            }
            if ("folder".equals(nodeName)) {
                for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!this.containsElmentWithId(child, id)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

