/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.Validate;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;
import org.jasig.portal.utils.Populator;

public class StylesheetUserPreferencesImpl
implements IStylesheetUserPreferences,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long stylesheetDescriptorId;
    private final int userId;
    private final int profileId;
    private final ConcurrentMap<String, String> outputProperties = new ConcurrentHashMap();
    private final ConcurrentMap<String, String> parameters = new ConcurrentHashMap();
    private final ConcurrentMap<String, ConcurrentMap<String, String>> layoutAttributes = new ConcurrentHashMap();

    public StylesheetUserPreferencesImpl(long stylesheetDescriptorId, int userId, int profileId) {
        this.stylesheetDescriptorId = stylesheetDescriptorId;
        this.userId = userId;
        this.profileId = profileId;
    }

    public long getId() {
        return -1L;
    }

    public long getStylesheetDescriptorId() {
        return this.stylesheetDescriptorId;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public String getOutputProperty(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.outputProperties.get(name);
    }

    public String setOutputProperty(String name, String value) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        return this.outputProperties.put(name, value);
    }

    public String removeOutputProperty(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.outputProperties.remove(name);
    }

    public <P extends Populator<String, String>> P populateOutputProperties(P properties) {
        properties.putAll((Map)this.outputProperties);
        return properties;
    }

    public void clearOutputProperties() {
        this.outputProperties.clear();
    }

    public String getStylesheetParameter(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.parameters.get(name);
    }

    public String setStylesheetParameter(String name, String value) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        return this.parameters.put(name, value);
    }

    public String removeStylesheetParameter(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.parameters.remove(name);
    }

    public <P extends Populator<String, String>> P populateStylesheetParameters(P stylesheetParameters) {
        stylesheetParameters.putAll((Map)this.parameters);
        return stylesheetParameters;
    }

    public void clearStylesheetParameters() {
        this.parameters.clear();
    }

    public String getLayoutAttribute(String nodeId, String name) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Map nodeAttributes = (Map)this.layoutAttributes.get(nodeId);
        if (nodeAttributes == null) {
            return null;
        }
        return (String)nodeAttributes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setLayoutAttribute(String nodeId, String name, String value) {
        ConcurrentHashMap<String, String> nodeAttributes;
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        ConcurrentMap concurrentMap = this.layoutAttributes;
        synchronized (concurrentMap) {
            nodeAttributes = (ConcurrentHashMap<String, String>)this.layoutAttributes.get(nodeId);
            if (nodeAttributes == null) {
                nodeAttributes = new ConcurrentHashMap<String, String>();
                this.layoutAttributes.put(nodeId, nodeAttributes);
            }
        }
        return nodeAttributes.put(name, value);
    }

    public String removeLayoutAttribute(String nodeId, String name) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Map nodeAttributes = (Map)this.layoutAttributes.get(nodeId);
        if (nodeAttributes == null) {
            return null;
        }
        return (String)nodeAttributes.remove(name);
    }

    public <P extends Populator<String, String>> P populateLayoutAttributes(String nodeId, P layoutAttributes) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Map nodeAttributes = (Map)this.layoutAttributes.get(nodeId);
        if (nodeAttributes != null) {
            layoutAttributes.putAll(nodeAttributes);
        }
        return layoutAttributes;
    }

    public Map<String, String> getAllNodesAndValuesForAttribute(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry layoutNodeAttributesEntry : this.layoutAttributes.entrySet()) {
            ConcurrentMap layoutNodeAttributes = (ConcurrentMap)layoutNodeAttributesEntry.getValue();
            String value = (String)layoutNodeAttributes.get(name);
            if (value == null) continue;
            String nodeId = (String)layoutNodeAttributesEntry.getKey();
            result.put((Object)nodeId, (Object)value);
        }
        return result.build();
    }

    public Collection<String> getAllLayoutAttributeNodeIds() {
        return Collections.unmodifiableSet(this.layoutAttributes.keySet());
    }

    public void clearLayoutAttributes(String nodeId) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        this.layoutAttributes.remove(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllLayoutAttributes() {
        ConcurrentMap concurrentMap = this.layoutAttributes;
        synchronized (concurrentMap) {
            this.layoutAttributes.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layoutAttributes == null ? 0 : this.layoutAttributes.hashCode());
        result = 31 * result + (this.outputProperties == null ? 0 : this.outputProperties.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StylesheetUserPreferencesImpl other = (StylesheetUserPreferencesImpl)obj;
        if (this.layoutAttributes == null ? other.layoutAttributes != null : !this.layoutAttributes.equals(other.layoutAttributes)) {
            return false;
        }
        if (this.outputProperties == null ? other.outputProperties != null : !this.outputProperties.equals(other.outputProperties)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    public String toString() {
        return "StylesheetUserPreferencesImpl [outputProperties=" + this.outputProperties + ", parameters=" + this.parameters + ", layoutAttributes=" + this.layoutAttributes + "]";
    }
}

