/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import java.util.Deque;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.TransientUserLayoutManagerWrapper;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.xml.stream.InjectingXMLEventReader;

public class TransientUserLayoutXMLEventReader
extends InjectingXMLEventReader {
    private static final XMLEventFactory EVENT_FACTORY = XMLEventFactory.newFactory();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransientUserLayoutManagerWrapper userLayoutManager;
    private final String rootFolderId;

    public TransientUserLayoutXMLEventReader(TransientUserLayoutManagerWrapper userLayoutManager, XMLEventReader wrappedReader) {
        super(wrappedReader);
        this.userLayoutManager = userLayoutManager;
        this.rootFolderId = this.userLayoutManager.getRootFolderId();
    }

    protected Deque<XMLEvent> getAdditionalEvents(XMLEvent event) {
        if (event.isStartElement()) {
            StartElement startElement = event.asStartElement();
            Attribute idAttribute = startElement.getAttributeByName(IUserLayoutManager.ID_ATTR_NAME);
            if (idAttribute == null) {
                return null;
            }
            if (this.rootFolderId.equals(idAttribute.getValue())) {
                QName name = startElement.getName();
                String namespaceURI = name.getNamespaceURI();
                String prefix = name.getPrefix();
                LinkedList<XMLEvent> transientEventBuffer = new LinkedList<XMLEvent>();
                LinkedList<Attribute> transientFolderAttributes = new LinkedList<Attribute>();
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("ID", "ft1"));
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("type", "regular"));
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("hidden", "true"));
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("unremovable", "true"));
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("immutable", "true"));
                transientFolderAttributes.add(EVENT_FACTORY.createAttribute("name", "Transient Folder"));
                StartElement transientFolder = EVENT_FACTORY.createStartElement(prefix, namespaceURI, "folder", transientFolderAttributes.iterator(), null);
                transientEventBuffer.add(transientFolder);
                String subscribeId = this.userLayoutManager.getFocusedId();
                if (null != subscribeId && !subscribeId.equals("") && this.userLayoutManager.isTransientChannel(subscribeId)) {
                    IPortletDefinition chanDef = null;
                    try {
                        chanDef = this.userLayoutManager.getChannelDefinition(subscribeId);
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Could not obtain IChannelDefinition for subscribe id: " + subscribeId), (Throwable)e);
                    }
                    if (chanDef != null) {
                        LinkedList<Attribute> channelAttrs = new LinkedList<Attribute>();
                        channelAttrs.add(EVENT_FACTORY.createAttribute("ID", subscribeId));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("typeID", Integer.toString(chanDef.getType().getId())));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("hidden", "false"));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("unremovable", "true"));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("name", chanDef.getName()));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("description", chanDef.getDescription()));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("title", chanDef.getTitle()));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("chanID", chanDef.getPortletDefinitionId().getStringId()));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("fname", chanDef.getFName()));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("timeout", Integer.toString(chanDef.getTimeout())));
                        channelAttrs.add(EVENT_FACTORY.createAttribute("transient", "true"));
                        StartElement startChannel = EVENT_FACTORY.createStartElement(prefix, namespaceURI, "channel", channelAttrs.iterator(), null);
                        transientEventBuffer.offer(startChannel);
                        for (IPortletDefinitionParameter parm : chanDef.getParameters()) {
                            LinkedList<Attribute> parameterAttrs = new LinkedList<Attribute>();
                            parameterAttrs.add(EVENT_FACTORY.createAttribute("name", parm.getName()));
                            parameterAttrs.add(EVENT_FACTORY.createAttribute("value", parm.getValue()));
                            StartElement startParameter = EVENT_FACTORY.createStartElement(prefix, namespaceURI, "parameter", parameterAttrs.iterator(), null);
                            transientEventBuffer.offer(startParameter);
                            EndElement endParameter = EVENT_FACTORY.createEndElement(prefix, namespaceURI, "parameter", null);
                            transientEventBuffer.offer(endParameter);
                        }
                        EndElement endChannel = EVENT_FACTORY.createEndElement(prefix, namespaceURI, "channel", null);
                        transientEventBuffer.offer(endChannel);
                    }
                }
                EndElement endFolder = EVENT_FACTORY.createEndElement(prefix, namespaceURI, "folder", null);
                transientEventBuffer.offer(endFolder);
                return transientEventBuffer;
            }
        }
        return null;
    }

    protected XMLEvent getPeekEvent(XMLEvent event) {
        Deque additionalEvents = this.getAdditionalEvents(event);
        if (additionalEvents != null) {
            return (XMLEvent)additionalEvents.pop();
        }
        return null;
    }
}

