/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutHelper;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.spring.locator.UserLayoutStoreLocator;
import org.jasig.services.persondir.IPersonAttributes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class UserLayoutHelperImpl
extends SimpleJdbcDaoSupport
implements IUserLayoutHelper {
    protected static final String DEFAULT_LAYOUT_FNAME = "default";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IUserIdentityStore userIdentityStore;

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userIdentityStore) {
        this.userIdentityStore = userIdentityStore;
    }

    public void resetUserLayout(IPersonAttributes personAttributes) {
        RestrictedPerson person = PersonFactory.createRestrictedPerson();
        person.setAttributes(personAttributes.getAttributes());
        int uid = this.userIdentityStore.getPortalUID((IPerson)person, false);
        person.setID(uid);
        IUserLayoutStore userLayoutStore = UserLayoutStoreLocator.getUserLayoutStore();
        try {
            IUserProfile userProfile = userLayoutStore.getUserProfileByFname((IPerson)person, DEFAULT_LAYOUT_FNAME);
            userProfile.setLayoutId(0);
            userLayoutStore.updateUserProfile((IPerson)person, userProfile);
            this.logger.info((Object)("resetUserLayout complete for " + person));
        }
        catch (Exception e) {
            String msg = "Exception caught during resetUserLayout for " + person;
            this.logger.error((Object)msg, (Throwable)e);
            throw new PortalException(msg, (Throwable)e);
        }
    }
}

