/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.Validate;
import org.jasig.portal.jpa.BaseJpaDao;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.jpa.OpenEntityManager;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl_;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.springframework.stereotype.Repository;

@Repository(value="stylesheetDescriptorDao")
public class JpaStylesheetDescriptorDao
extends BasePortalJpaDao
implements IStylesheetDescriptorDao {
    private CriteriaQuery<StylesheetDescriptorImpl> findAllDescriptors;

    public void afterPropertiesSet() throws Exception {
        this.findAllDescriptors = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @BasePortalJpaDao.PortalTransactional
    public IStylesheetDescriptor createStylesheetDescriptor(String name, String stylesheetResource) {
        StylesheetDescriptorImpl stylesheetDescriptor = new StylesheetDescriptorImpl(name, stylesheetResource);
        this.getEntityManager().persist((Object)stylesheetDescriptor);
        return stylesheetDescriptor;
    }

    public List<? extends IStylesheetDescriptor> getStylesheetDescriptors() {
        TypedQuery query = this.createCachedQuery(this.findAllDescriptors);
        List results = query.getResultList();
        return new ArrayList(new LinkedHashSet(results));
    }

    public IStylesheetDescriptor getStylesheetDescriptor(long id) {
        StylesheetDescriptorImpl stylesheetDescriptor = (StylesheetDescriptorImpl)this.getEntityManager().find(StylesheetDescriptorImpl.class, (Object)id);
        return stylesheetDescriptor;
    }

    @OpenEntityManager(unitName="PortalDb")
    public IStylesheetDescriptor getStylesheetDescriptorByName(String name) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(StylesheetDescriptorImpl.class);
        query.using((Attribute)StylesheetDescriptorImpl_.name, (Object)name);
        return (IStylesheetDescriptor)query.load();
    }

    @BasePortalJpaDao.PortalTransactional
    public void updateStylesheetDescriptor(IStylesheetDescriptor stylesheetDescriptor) {
        Validate.notNull((Object)stylesheetDescriptor, (String)"stylesheetDescriptor can not be null");
        this.getEntityManager().persist((Object)stylesheetDescriptor);
    }

    @BasePortalJpaDao.PortalTransactional
    public void deleteStylesheetDescriptor(IStylesheetDescriptor stylesheetDescriptor) {
        Validate.notNull((Object)stylesheetDescriptor, (String)"definition can not be null");
        EntityManager entityManager = this.getEntityManager();
        IStylesheetDescriptor persistentStylesheetDescriptor = entityManager.contains((Object)stylesheetDescriptor) ? stylesheetDescriptor : (IStylesheetDescriptor)entityManager.merge((Object)stylesheetDescriptor);
        entityManager.remove((Object)persistentStylesheetDescriptor);
    }
}

