/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dao.jpa;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.PluralAttribute;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.layout.dao.IStylesheetUserPreferencesDao;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetUserPreferencesImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetUserPreferencesImpl_;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;
import org.jasig.portal.security.IPerson;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository(value="stylesheetUserPreferencesDao")
public class JpaStylesheetUserPreferencesDao
extends BasePortalJpaDao
implements IStylesheetUserPreferencesDao {
    private CriteriaQuery<StylesheetUserPreferencesImpl> findAllPreferences;
    private CriteriaQuery<StylesheetUserPreferencesImpl> findAllPreferencesForUser;
    private CriteriaQuery<StylesheetUserPreferencesImpl> findPreferencesByDescriptorUserProfileQuery;
    private ParameterExpression<StylesheetDescriptorImpl> stylesheetDescriptorParameter;
    private ParameterExpression<Integer> userIdParameter;
    private ParameterExpression<Integer> profileIdParameter;

    public void afterPropertiesSet() throws Exception {
        this.stylesheetDescriptorParameter = this.createParameterExpression(StylesheetDescriptorImpl.class, "stylesheetDescriptor");
        this.userIdParameter = this.createParameterExpression(Integer.class, "userId");
        this.profileIdParameter = this.createParameterExpression(Integer.class, "profileId");
        this.findAllPreferences = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findPreferencesByDescriptorUserProfileQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAllPreferencesForUser = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void addFetches(Root<StylesheetUserPreferencesImpl> descriptorRoot) {
        descriptorRoot.fetch((PluralAttribute)StylesheetUserPreferencesImpl_.layoutAttributes, JoinType.LEFT);
        descriptorRoot.fetch((PluralAttribute)StylesheetUserPreferencesImpl_.outputProperties, JoinType.LEFT);
        descriptorRoot.fetch((PluralAttribute)StylesheetUserPreferencesImpl_.parameters, JoinType.LEFT);
    }

    public List<? extends IStylesheetUserPreferences> getStylesheetUserPreferencesForUser(int personId) {
        TypedQuery query = this.createCachedQuery(this.findAllPreferencesForUser);
        query.setParameter((Parameter)this.userIdParameter, (Object)personId);
        return query.getResultList();
    }

    @BasePortalJpaDao.PortalTransactional
    public IStylesheetUserPreferences createStylesheetUserPreferences(IStylesheetDescriptor stylesheetDescriptor, IPerson person, IUserProfile profile) {
        int userId = person.getID();
        int profileId = profile.getProfileId();
        StylesheetUserPreferencesImpl stylesheetUserPreferences = new StylesheetUserPreferencesImpl(stylesheetDescriptor, userId, profileId);
        this.getEntityManager().persist((Object)stylesheetUserPreferences);
        return stylesheetUserPreferences;
    }

    @BasePortalJpaDao.PortalTransactional
    public IStylesheetUserPreferences createStylesheetUserPreferences(IStylesheetDescriptor stylesheetDescriptor, int userId, int profileId) {
        StylesheetUserPreferencesImpl stylesheetUserPreferences = new StylesheetUserPreferencesImpl(stylesheetDescriptor, userId, profileId);
        this.getEntityManager().persist((Object)stylesheetUserPreferences);
        return stylesheetUserPreferences;
    }

    public List<? extends IStylesheetUserPreferences> getStylesheetUserPreferences() {
        TypedQuery query = this.createCachedQuery(this.findAllPreferences);
        return query.getResultList();
    }

    public IStylesheetUserPreferences getStylesheetUserPreferences(long id) {
        return (IStylesheetUserPreferences)this.getEntityManager().find(StylesheetUserPreferencesImpl.class, (Object)id);
    }

    public IStylesheetUserPreferences getStylesheetUserPreferences(IStylesheetDescriptor stylesheetDescriptor, IPerson person, IUserProfile profile) {
        return this.getStylesheetUserPreferences(stylesheetDescriptor, person.getID(), profile.getProfileId());
    }

    @Deprecated
    public IStylesheetUserPreferences getStylesheetUserPreferences(IStylesheetDescriptor stylesheetDescriptor, int personId, int profileId) {
        TypedQuery query = this.createCachedQuery(this.findPreferencesByDescriptorUserProfileQuery);
        query.setParameter((Parameter)this.stylesheetDescriptorParameter, (Object)((StylesheetDescriptorImpl)stylesheetDescriptor));
        query.setParameter((Parameter)this.userIdParameter, (Object)personId);
        query.setParameter((Parameter)this.profileIdParameter, (Object)profileId);
        List results = query.getResultList();
        return (IStylesheetUserPreferences)DataAccessUtils.uniqueResult((Collection)results);
    }

    @BasePortalJpaDao.PortalTransactional
    public void storeStylesheetUserPreferences(IStylesheetUserPreferences stylesheetUserPreferences) {
        this.getEntityManager().persist((Object)stylesheetUserPreferences);
    }

    @BasePortalJpaDao.PortalTransactional
    public void deleteStylesheetUserPreferences(IStylesheetUserPreferences stylesheetUserPreferences) {
        this.getEntityManager().remove((Object)stylesheetUserPreferences);
    }

    static /* synthetic */ ParameterExpression access$000(JpaStylesheetUserPreferencesDao x0) {
        return x0.userIdParameter;
    }

    static /* synthetic */ ParameterExpression access$100(JpaStylesheetUserPreferencesDao x0) {
        return x0.stylesheetDescriptorParameter;
    }

    static /* synthetic */ ParameterExpression access$200(JpaStylesheetUserPreferencesDao x0) {
        return x0.profileIdParameter;
    }
}

