/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dao.jpa;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;

@Entity
@Table(name="UP_SS_USER_PREF_LAY_ATTR")
@SequenceGenerator(name="UP_SS_USER_PREF_LAY_ATTR_GEN", sequenceName="UP_SS_USER_PREF_LAY_ATTR_SEQ", allocationSize=5)
@TableGenerator(name="UP_SS_USER_PREF_LAY_ATTR_GEN", pkColumnValue="UP_SS_USER_PREF_LAY_ATTR", allocationSize=5)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class LayoutNodeAttributesImpl {
    @Id
    @GeneratedValue(generator="UP_SS_USER_PREF_LAY_ATTR_GEN")
    @Column(name="UP_SS_USER_PREF_LAY_ATTR_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @Column(name="NODE_ID", nullable=false, length=200)
    private final String nodeId;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="ATTR_NAME", nullable=false, length=500)
    @Column(name="ATTR_VALUE", nullable=false, length=2000)
    @Type(type="nullSafeString")
    @CollectionTable(name="UP_SS_USER_PREF_LAY_ATTR_VAL", joinColumns={@JoinColumn(name="UP_SS_USER_PREF_LAY_ATTR_ID", nullable=false)})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private Map<String, String> attributes = new LinkedHashMap(0);

    private LayoutNodeAttributesImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.nodeId = null;
    }

    public LayoutNodeAttributesImpl(String nodeId) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        this.id = -1L;
        this.entityVersion = -1L;
        this.nodeId = nodeId;
    }

    public LayoutNodeAttributesImpl(String nodeId, Map<String, String> attributes) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        this.id = -1L;
        this.entityVersion = -1L;
        this.nodeId = nodeId;
        this.attributes.putAll(attributes);
    }

    public long getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayoutNodeAttributesImpl other = (LayoutNodeAttributesImpl)obj;
        return !(this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId));
    }

    public String toString() {
        return "LayoutNodeAttributesImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", nodeId=" + this.nodeId + "]";
    }
}

