/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dao.jpa;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.jasig.portal.layout.dao.jpa.LayoutNodeAttributesImpl;
import org.jasig.portal.layout.dao.jpa.StylesheetDescriptorImpl;
import org.jasig.portal.layout.om.IStylesheetDescriptor;
import org.jasig.portal.layout.om.IStylesheetUserPreferences;
import org.jasig.portal.utils.Populator;

@Entity
@Table(name="UP_SS_USER_PREF")
@SequenceGenerator(name="UP_SS_USER_PREF_GEN", sequenceName="UP_SS_USER_PREF_SEQ", allocationSize=5)
@TableGenerator(name="UP_SS_USER_PREF_GEN", pkColumnValue="UP_SS_USER_PREF", allocationSize=5)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class StylesheetUserPreferencesImpl
implements IStylesheetUserPreferences {
    @Id
    @GeneratedValue(generator="UP_SS_USER_PREF_GEN")
    @Column(name="SS_USER_PREF_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @ManyToOne(targetEntity=StylesheetDescriptorImpl.class, optional=false)
    @JoinColumn(name="UP_SS_DESCRIPTOR_ID", nullable=false)
    private final IStylesheetDescriptor stylesheetDescriptor;
    @NaturalId
    @Column(name="USER_ID", nullable=false, updatable=false)
    private final int userId;
    @NaturalId
    @Column(name="PROFILE_ID", nullable=false, updatable=false)
    private final int profileId;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="PROP_NAME", nullable=false, length=500)
    @Column(name="PROP_VALUE", nullable=false, length=2000)
    @Type(type="nullSafeString")
    @CollectionTable(name="UP_SS_USER_PREF_OUTPUT_PROP", joinColumns={@JoinColumn(name="SS_USER_PREF_ID", nullable=false)})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Map<String, String> outputProperties = new LinkedHashMap(0);
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="PARAM_NAME", nullable=false, length=500)
    @Column(name="PARAM_VALUE", nullable=false, length=2000)
    @Type(type="nullSafeString")
    @CollectionTable(name="UP_SS_USER_PREF_PARAM", joinColumns={@JoinColumn(name="SS_USER_PREF_ID", nullable=false)})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Map<String, String> parameters = new LinkedHashMap(0);
    @OneToMany(targetEntity=LayoutNodeAttributesImpl.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, orphanRemoval=true)
    @MapKey(name="nodeId")
    @JoinColumn(name="SS_USER_PREF_ID", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @Fetch(value=FetchMode.JOIN)
    private final Map<String, LayoutNodeAttributesImpl> layoutAttributes = new LinkedHashMap(0);

    private StylesheetUserPreferencesImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
        this.stylesheetDescriptor = null;
        this.userId = -1;
        this.profileId = -1;
    }

    StylesheetUserPreferencesImpl(IStylesheetDescriptor stylesheetDescriptor, int userId, int profileId) {
        this.id = -1L;
        this.entityVersion = -1L;
        this.stylesheetDescriptor = stylesheetDescriptor;
        this.userId = userId;
        this.profileId = profileId;
    }

    @PrePersist
    private void purgeEmptyLayoutNodes() {
        Iterator layoutNodeAttrsItr = this.layoutAttributes.values().iterator();
        while (layoutNodeAttrsItr.hasNext()) {
            LayoutNodeAttributesImpl layoutNodeAttrs = (LayoutNodeAttributesImpl)layoutNodeAttrsItr.next();
            if (!layoutNodeAttrs.getAttributes().isEmpty()) continue;
            layoutNodeAttrsItr.remove();
        }
    }

    public long getId() {
        return this.id;
    }

    public long getStylesheetDescriptorId() {
        return this.stylesheetDescriptor.getId();
    }

    public int getUserId() {
        return this.userId;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public String getOutputProperty(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.outputProperties.get(name);
    }

    public String setOutputProperty(String name, String value) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        return this.outputProperties.put(name, value);
    }

    public String removeOutputProperty(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.outputProperties.remove(name);
    }

    public <P extends Populator<String, String>> P populateOutputProperties(P properties) {
        properties.putAll(this.outputProperties);
        return properties;
    }

    public void clearOutputProperties() {
        this.outputProperties.clear();
    }

    public String getStylesheetParameter(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.parameters.get(name);
    }

    public String setStylesheetParameter(String name, String value) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        return this.parameters.put(name, value);
    }

    public String removeStylesheetParameter(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        return (String)this.parameters.remove(name);
    }

    public <P extends Populator<String, String>> P populateStylesheetParameters(P stylesheetParameters) {
        stylesheetParameters.putAll(this.parameters);
        return stylesheetParameters;
    }

    public void clearStylesheetParameters() {
        this.parameters.clear();
    }

    protected LayoutNodeAttributesImpl getLayoutNodeAttributes(String nodeId, boolean create) {
        LayoutNodeAttributesImpl layoutAttribute = (LayoutNodeAttributesImpl)this.layoutAttributes.get(nodeId);
        if (layoutAttribute != null) {
            return layoutAttribute;
        }
        if (!create) {
            return null;
        }
        layoutAttribute = new LayoutNodeAttributesImpl(nodeId);
        this.layoutAttributes.put(nodeId, layoutAttribute);
        return layoutAttribute;
    }

    public String getLayoutAttribute(String nodeId, String name) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        LayoutNodeAttributesImpl layoutAttribute = this.getLayoutNodeAttributes(nodeId, true);
        Map attributes = layoutAttribute.getAttributes();
        return (String)attributes.get(name);
    }

    public Map<String, String> getAllNodesAndValuesForAttribute(String name) {
        Validate.notEmpty((String)name, (String)"name cannot be null");
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry layoutNodeAttributesEntry : this.layoutAttributes.entrySet()) {
            LayoutNodeAttributesImpl layoutNodeAttributes = (LayoutNodeAttributesImpl)layoutNodeAttributesEntry.getValue();
            String value = (String)layoutNodeAttributes.getAttributes().get(name);
            if (value == null) continue;
            String nodeId = (String)layoutNodeAttributesEntry.getKey();
            result.put((Object)nodeId, (Object)value);
        }
        return result.build();
    }

    public String setLayoutAttribute(String nodeId, String name, String value) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        Validate.notEmpty((String)value, (String)"value cannot be null");
        LayoutNodeAttributesImpl layoutAttribute = this.getLayoutNodeAttributes(nodeId, true);
        Map attributes = layoutAttribute.getAttributes();
        return attributes.put(name, value);
    }

    public String removeLayoutAttribute(String nodeId, String name) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        Validate.notEmpty((String)name, (String)"name cannot be null");
        LayoutNodeAttributesImpl layoutAttribute = this.getLayoutNodeAttributes(nodeId, false);
        if (layoutAttribute == null) {
            return null;
        }
        Map attributes = layoutAttribute.getAttributes();
        return (String)attributes.remove(name);
    }

    public <P extends Populator<String, String>> P populateLayoutAttributes(String nodeId, P layoutAttributes) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        LayoutNodeAttributesImpl nodeAttributes = (LayoutNodeAttributesImpl)this.layoutAttributes.get(nodeId);
        if (nodeAttributes != null) {
            layoutAttributes.putAll(nodeAttributes.getAttributes());
        }
        return layoutAttributes;
    }

    public Collection<String> getAllLayoutAttributeNodeIds() {
        return Collections.unmodifiableSet(this.layoutAttributes.keySet());
    }

    public void clearLayoutAttributes(String nodeId) {
        Validate.notEmpty((String)nodeId, (String)"nodeId cannot be null");
        this.layoutAttributes.remove(nodeId);
    }

    public void clearAllLayoutAttributes() {
        this.layoutAttributes.clear();
    }

    public String toString() {
        return "StylesheetUserPreferencesImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", stylesheetDescriptor=" + this.stylesheetDescriptor + ", userId=" + this.userId + ", profileId=" + this.profileId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.profileId;
        result = 31 * result + (this.stylesheetDescriptor == null ? 0 : this.stylesheetDescriptor.hashCode());
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StylesheetUserPreferencesImpl other = (StylesheetUserPreferencesImpl)obj;
        if (this.profileId != other.profileId) {
            return false;
        }
        if (this.stylesheetDescriptor == null ? other.stylesheetDescriptor != null : !this.stylesheetDescriptor.equals(other.stylesheetDescriptor)) {
            return false;
        }
        return this.userId == other.userId;
    }
}

