/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.UserLayoutStoreLocator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditManager {
    public static final String RCS_ID = "@(#) $Header$";
    private static IUserLayoutStore dls = null;
    private static final Log LOG = LogFactory.getLog(EditManager.class);

    private static IUserLayoutStore getDLS() {
        if (dls == null) {
            dls = UserLayoutStoreLocator.getUserLayoutStore();
        }
        return dls;
    }

    private static Element getEditSet(Element node, Document plf, IPerson person, boolean create) throws PortalException {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("dlm:editSet")) continue;
            return (Element)child;
        }
        if (!create) {
            return null;
        }
        String ID = null;
        try {
            ID = EditManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new edit set node Id for userId=" + person.getID(), (Throwable)e);
        }
        Element editSet = plf.createElement("dlm:editSet");
        editSet.setAttribute("type", "dlm:editSet");
        editSet.setAttribute("ID", ID);
        node.appendChild(editSet);
        return editSet;
    }

    static void addEditDirective(Element plfNode, String attributeName, IPerson person) throws PortalException {
        EditManager.addDirective((Element)plfNode, (String)attributeName, (String)"dlm:edit", (IPerson)person);
    }

    public static void addPrefsDirective(Element plfNode, String attributeName, IPerson person) throws PortalException {
        EditManager.addDirective((Element)plfNode, (String)attributeName, (String)"dlm:pref", (IPerson)person);
    }

    private static void addDirective(Element plfNode, String attributeName, String type, IPerson person) throws PortalException {
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element editSet = EditManager.getEditSet((Element)plfNode, (Document)plf, (IPerson)person, (boolean)true);
        Element edit = null;
        for (Element child = (Element)editSet.getFirstChild(); child != null && edit == null; child = (Element)child.getNextSibling()) {
            if (!child.getNodeName().equals(type) || !child.getAttribute("name").equals(attributeName)) continue;
            edit = child;
        }
        if (edit == null) {
            String ID = null;
            try {
                ID = EditManager.getDLS().getNextStructDirectiveId(person);
            }
            catch (Exception e) {
                throw new PortalException("Exception encountered while generating new edit node Id for userId=" + person.getID(), (Throwable)e);
            }
            edit = plf.createElement(type);
            edit.setAttribute("type", type);
            edit.setAttribute("ID", ID);
            edit.setAttribute("name", attributeName);
            editSet.appendChild(edit);
        }
    }

    public static boolean applyEditSet(Element plfChild, Element original) {
        Element editSet = null;
        try {
            editSet = EditManager.getEditSet((Element)plfChild, null, null, (boolean)false);
        }
        catch (Exception e) {
            return false;
        }
        if (editSet == null || editSet.getChildNodes().getLength() == 0) {
            return false;
        }
        if (original.getAttribute("dlm:editAllowed").equals("false")) {
            plfChild.removeChild(editSet);
            return false;
        }
        Document ilf = original.getOwnerDocument();
        boolean attributeChanged = false;
        for (Element edit = (Element)editSet.getFirstChild(); edit != null; edit = (Element)edit.getNextSibling()) {
            String attribName = edit.getAttribute("name");
            Attr attr = plfChild.getAttributeNode(attribName);
            if (edit.getNodeName().equals("dlm:pref")) {
                attributeChanged = true;
                continue;
            }
            if (attr == null) {
                attr = original.getAttributeNode(attribName);
                if (attr == null) {
                    editSet.removeChild(edit);
                    continue;
                }
                original.removeAttribute(attribName);
                attributeChanged = true;
                continue;
            }
            Attr origAttr = original.getAttributeNode(attribName);
            if (origAttr == null) {
                origAttr = (Attr)ilf.importNode(attr, true);
                original.setAttributeNode(origAttr);
                attributeChanged = true;
                continue;
            }
            if (attr.getValue().equals(origAttr.getValue())) {
                editSet.removeChild(edit);
                continue;
            }
            origAttr.setValue(attr.getValue());
            attributeChanged = true;
        }
        return attributeChanged;
    }

    public static void removePreferenceDirective(IPerson person, String elementId, String attributeName) {
        EditManager.removeDirective((String)elementId, (String)attributeName, (String)"dlm:pref", (IPerson)person);
    }

    public static void removeEditDirective(String elementId, String attributeName, IPerson person) {
        EditManager.removeDirective((String)elementId, (String)attributeName, (String)"dlm:edit", (IPerson)person);
    }

    private static void removeDirective(String elementId, String attributeName, String type, IPerson person) {
        Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
        Element node = plf.getElementById(elementId);
        if (node == null) {
            return;
        }
        Element editSet = null;
        try {
            editSet = EditManager.getEditSet((Element)node, (Document)plf, (IPerson)person, (boolean)false);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return;
        }
        if (editSet == null) {
            return;
        }
        for (Node child = editSet.getFirstChild(); child != null; child = child.getNextSibling()) {
            Attr attr;
            if (!child.getNodeName().equals(type) || (attr = ((Element)child).getAttributeNode("name")) == null || !attr.getValue().equals(attributeName)) continue;
            editSet.removeChild(child);
            break;
        }
        if (editSet.getFirstChild() == null) {
            node.removeChild(editSet);
        }
    }
}

