/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.lang.Validate;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.IFragmentDefinitionDao;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository
public class FragmentDefinitionDao
extends BasePortalJpaDao
implements IFragmentDefinitionDao {
    private CriteriaQuery<FragmentDefinition> findAllFragmentsQuery;
    private CriteriaQuery<FragmentDefinition> findFragmentByNameQuery;
    private CriteriaQuery<FragmentDefinition> findFragmentByOwnerQuery;
    private ParameterExpression<String> nameParameter;
    private ParameterExpression<String> ownerParameter;

    public void afterPropertiesSet() throws Exception {
        this.nameParameter = this.createParameterExpression(String.class, "name");
        this.ownerParameter = this.createParameterExpression(String.class, "ownerId");
        this.findAllFragmentsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findFragmentByNameQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findFragmentByOwnerQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<FragmentDefinition> getAllFragments() {
        TypedQuery query = this.createCachedQuery(this.findAllFragmentsQuery);
        List rslt = query.getResultList();
        return rslt;
    }

    public FragmentDefinition getFragmentDefinition(String name) {
        TypedQuery query = this.createCachedQuery(this.findFragmentByNameQuery);
        query.setParameter((Parameter)this.nameParameter, (Object)name);
        List list = query.getResultList();
        FragmentDefinition rslt = (FragmentDefinition)DataAccessUtils.uniqueResult((Collection)list);
        return rslt;
    }

    public FragmentDefinition getFragmentDefinitionByOwner(String ownerId) {
        TypedQuery query = this.createCachedQuery(this.findFragmentByOwnerQuery);
        query.setParameter((Parameter)this.ownerParameter, (Object)ownerId);
        List list = query.getResultList();
        FragmentDefinition rslt = (FragmentDefinition)DataAccessUtils.uniqueResult((Collection)list);
        return rslt;
    }

    @BasePortalJpaDao.PortalTransactional
    public void updateFragmentDefinition(FragmentDefinition fd) {
        Validate.notNull((Object)fd, (String)"FragmentDefinition can not be null");
        this.getEntityManager().persist((Object)fd);
    }

    @BasePortalJpaDao.PortalTransactional
    public void removeFragmentDefinition(FragmentDefinition fd) {
        Validate.notNull((Object)fd, (String)"FragmentDefinition can not be null");
        EntityManager entityManager = this.getEntityManager();
        FragmentDefinition persistentFragmentDefinition = entityManager.contains((Object)fd) ? fd : (FragmentDefinition)entityManager.merge((Object)fd);
        entityManager.remove((Object)persistentFragmentDefinition);
    }

    static /* synthetic */ ParameterExpression access$000(FragmentDefinitionDao x0) {
        return x0.nameParameter;
    }

    static /* synthetic */ ParameterExpression access$100(FragmentDefinitionDao x0) {
        return x0.ownerParameter;
    }
}

