/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.IntegrationResult;
import org.jasig.portal.layout.dlm.NodeInfo;
import org.jasig.portal.layout.dlm.PositionManager;
import org.jasig.portal.layout.dlm.Precedence;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.UserLayoutStoreLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class PositionManager {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(PositionManager.class);
    private static IUserLayoutStore dls = null;

    private static IUserLayoutStore getDLS() {
        if (dls == null) {
            dls = UserLayoutStoreLocator.getUserLayoutStore();
        }
        return dls;
    }

    static void applyPositions(Element compViewParent, Element positionSet, IntegrationResult result) throws PortalException {
        if (positionSet == null || positionSet.getFirstChild() == null) {
            return;
        }
        ArrayList order = new ArrayList();
        PositionManager.applyOrdering(order, (Element)compViewParent, (Element)positionSet);
        PositionManager.applyNoReparenting(order, (Element)compViewParent, (Element)positionSet);
        PositionManager.applyNoHopping(order, (Element)compViewParent, (Element)positionSet);
        PositionManager.applyLowerPrecedence(order, (Element)compViewParent, (Element)positionSet);
        PositionManager.evaluateAndApply(order, (Element)compViewParent, (Element)positionSet, (IntegrationResult)result);
    }

    static void evaluateAndApply(List<NodeInfo> order, Element compViewParent, Element positionSet, IntegrationResult result) throws PortalException {
        PositionManager.adjustPositionSet(order, (Element)positionSet, (IntegrationResult)result);
        if (PositionManager.hasAffectOnCVP(order, (Element)compViewParent)) {
            PositionManager.applyToNodes(order, (Element)compViewParent);
            result.changedILF = true;
        }
    }

    static void adjustPositionSet(List<NodeInfo> order, Element positionSet, IntegrationResult result) {
        Node nodeToMatch = positionSet.getFirstChild();
        Element nodeToInsertBefore = positionSet.getOwnerDocument().createElement("INSERT_POINT");
        positionSet.insertBefore(nodeToInsertBefore, nodeToMatch);
        for (NodeInfo ni : order) {
            if (ni.positionDirective == null) continue;
            if (ni.positionDirective != nodeToMatch) {
                result.changedPLF = true;
            }
            if (nodeToMatch != null) {
                nodeToMatch = nodeToMatch.getNextSibling();
            }
            positionSet.insertBefore(ni.positionDirective, nodeToInsertBefore);
        }
        while (nodeToInsertBefore.getNextSibling() != null) {
            positionSet.removeChild(nodeToInsertBefore.getNextSibling());
        }
        positionSet.removeChild(nodeToInsertBefore);
    }

    static boolean hasAffectOnCVP(List<NodeInfo> order, Element compViewParent) {
        Element child;
        if (order.size() == 0) {
            return false;
        }
        int idx = 0;
        NodeInfo ni = order.get(idx);
        if (child == null && ni != null) {
            return true;
        }
        for (child = (Element)compViewParent.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (!child.getAttribute("hidden").equals("false") || child.getAttribute("chanID").equals("") && !child.getAttribute("type").equals("regular")) continue;
            if (ni.id.equals(child.getAttribute("ID"))) {
                if (idx >= order.size() - 1) {
                    return false;
                }
                ni = order.get(++idx);
                continue;
            }
            return true;
        }
        return idx < order.size();
    }

    static void applyToNodes(List<NodeInfo> order, Element compViewParent) {
        Element insertPoint = compViewParent.getOwnerDocument().createElement("bogus");
        Node first = compViewParent.getFirstChild();
        if (first != null) {
            compViewParent.insertBefore(insertPoint, first);
        } else {
            compViewParent.appendChild(insertPoint);
        }
        for (int i = 0; i < order.size(); ++i) {
            compViewParent.insertBefore(order.get((int)i).node, insertPoint);
        }
        compViewParent.removeChild(insertPoint);
    }

    static void applyLowerPrecedence(List<NodeInfo> order, Element compViewParent, Element positionSet) {
        for (int i = 0; i < order.size(); ++i) {
            NodeInfo ni = order.get(i);
            if (!ni.node.getAttribute("dlm:moveAllowed").equals("false")) continue;
            for (int j = 0; j < i; ++j) {
                NodeInfo lefty = order.get(j);
                if (lefty.precedence != null && !lefty.precedence.isLessThan(ni.precedence)) continue;
                order.remove(j);
                order.add(i, lefty);
            }
        }
    }

    static void applyNoHopping(List<NodeInfo> order, Element compViewParent, Element positionSet) {
        if (PositionManager.isIllegalHoppingSpecified(order)) {
            ArrayList<NodeInfo> cvpNodeInfos = new ArrayList<NodeInfo>();
            for (int i = order.size() - 1; i >= 0; --i) {
                if (order.get((int)i).indexInCVP == -1) continue;
                cvpNodeInfos.add(order.remove(i));
            }
            Object[] nodeInfos = cvpNodeInfos.toArray();
            Arrays.sort(nodeInfos, new NodeInfoComparator());
            List<Object> list = Arrays.asList(nodeInfos);
            order.addAll(0, list);
        }
    }

    static boolean isIllegalHoppingSpecified(List<NodeInfo> order) {
        for (int i = 0; i < order.size(); ++i) {
            NodeInfo niSib;
            int j;
            NodeInfo ni = order.get(i);
            if (!ni.node.getAttribute("dlm:moveAllowed").equals("false")) continue;
            for (j = 0; j < i; ++j) {
                niSib = order.get(j);
                if (niSib.precedence == Precedence.getUserPrecedence() || !niSib.precedence.isEqualTo(ni.precedence) || niSib.indexInCVP != -1 && ni.indexInCVP >= niSib.indexInCVP) continue;
                return true;
            }
            for (j = i + 1; j < order.size(); ++j) {
                niSib = order.get(j);
                if (niSib.indexInCVP == -1 || niSib.precedence == Precedence.getUserPrecedence() || ni.indexInCVP <= niSib.indexInCVP || !niSib.precedence.isEqualTo(ni.precedence)) continue;
                return true;
            }
        }
        return false;
    }

    static void applyNoReparenting(List<NodeInfo> order, Element compViewParent, Element positionSet) {
        int i = 0;
        while (i < order.size()) {
            NodeInfo ni = order.get(i);
            if (!ni.node.getParentNode().equals(compViewParent)) {
                ni.differentParent = true;
                if (PositionManager.isNotReparentable((NodeInfo)ni)) {
                    ni.positionDirective = null;
                    order.remove(i);
                    continue;
                }
            }
            ++i;
        }
    }

    private static boolean isNotReparentable(NodeInfo ni) {
        if (ni.node.getAttribute("dlm:moveAllowed").equals("false")) {
            return true;
        }
        Precedence nodePrec = ni.precedence;
        for (Element node = (Element)ni.node.getNextSibling(); node != null; node = (Element)node.getNextSibling()) {
            Precedence p;
            if (!node.getAttribute("dlm:moveAllowed").equals("false") || !nodePrec.isEqualTo(p = Precedence.newInstance((String)node.getAttribute("dlm:fragment")))) continue;
            return true;
        }
        return false;
    }

    static void applyOrdering(List<NodeInfo> order, Element compViewParent, Element positionSet) {
        LinkedHashMap<String, NodeInfo> available = new LinkedHashMap<String, NodeInfo>();
        Element child = (Element)compViewParent.getFirstChild();
        Element next = null;
        int indexInCVP = 0;
        while (child != null) {
            NodeInfo nodeInfo;
            NodeInfo prevNode;
            next = (Element)child.getNextSibling();
            if (child.getAttribute("hidden").equals("false") && (!child.getAttribute("chanID").equals("") || child.getAttribute("type").equals("regular")) && (prevNode = available.put(nodeInfo.id, nodeInfo = new NodeInfo(child, indexInCVP++))) != null) {
                throw new IllegalStateException("Infinite loop detected in layout. Triggered by " + nodeInfo.id + " with already visited node ids: " + available.keySet());
            }
            child = next;
        }
        Document CV = compViewParent.getOwnerDocument();
        Element directive = (Element)positionSet.getFirstChild();
        while (directive != null) {
            next = (Element)directive.getNextSibling();
            String id = directive.getAttribute("name");
            child = CV.getElementById(id);
            if (child != null) {
                String childId = child.getAttribute("ID");
                NodeInfo ni = (NodeInfo)available.remove(childId);
                if (ni == null) {
                    ni = new NodeInfo(child);
                }
                ni.positionDirective = directive;
                order.add(ni);
            }
            directive = next;
        }
        order.addAll(available.values());
    }

    public static void updatePositionSet(Element compViewParent, Element plfParent, IPerson person) throws PortalException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Updating Position Set");
        }
        if (compViewParent.getChildNodes().getLength() == 0) {
            Element positions;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Nodes to position");
            }
            if ((positions = PositionManager.getPositionSet((Element)plfParent, (IPerson)person, (boolean)false)) != null) {
                plfParent.removeChild(positions);
            }
            return;
        }
        Element posSet = PositionManager.getPositionSet((Element)plfParent, (IPerson)person, (boolean)true);
        Element position = (Element)posSet.getFirstChild();
        boolean ilfNodesFound = false;
        for (Element viewNode = (Element)compViewParent.getFirstChild(); viewNode != null; viewNode = (Element)viewNode.getNextSibling()) {
            String ID = viewNode.getAttribute("ID");
            String channelId = viewNode.getAttribute("chanID");
            String type = viewNode.getAttribute("type");
            String hidden = viewNode.getAttribute("hidden");
            if (ID.startsWith("u")) {
                ilfNodesFound = true;
            }
            if (channelId.equals("") && (!type.equals("regular") || !hidden.equals("false"))) continue;
            if (position != null) {
                position.setAttribute("name", ID);
            } else {
                position = PositionManager.createAndAppendPosition((String)ID, (Element)posSet, (IPerson)person);
            }
            position = (Element)position.getNextSibling();
        }
        if (!ilfNodesFound) {
            plfParent.removeChild(posSet);
        } else {
            while (position != null) {
                Element nextPos = (Element)position.getNextSibling();
                posSet.removeChild(position);
                position = nextPos;
            }
        }
    }

    private static Element getPositionSet(Element plfParent, IPerson person, boolean create) throws PortalException {
        for (Node child = plfParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("dlm:positionSet")) continue;
            return (Element)child;
        }
        if (!create) {
            return null;
        }
        String ID = null;
        try {
            ID = PositionManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new position set node Id for userId=" + person.getID(), (Throwable)e);
        }
        Document plf = plfParent.getOwnerDocument();
        Element positions = plf.createElement("dlm:positionSet");
        positions.setAttribute("type", "dlm:positionSet");
        positions.setAttribute("ID", ID);
        plfParent.appendChild(positions);
        return positions;
    }

    private static Element createAndAppendPosition(String elementID, Element positions, IPerson person) throws PortalException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding Position Set entry " + elementID + "."));
        }
        String ID = null;
        try {
            ID = PositionManager.getDLS().getNextStructDirectiveId(person);
        }
        catch (Exception e) {
            throw new PortalException("Exception encountered while generating new position node Id for userId=" + person.getID(), (Throwable)e);
        }
        Document plf = positions.getOwnerDocument();
        Element position = plf.createElement("dlm:position");
        position.setAttribute("type", "dlm:position");
        position.setAttribute("ID", ID);
        position.setAttributeNS("http://www.uportal.org/layout/dlm", "name", elementID);
        positions.appendChild(position);
        return position;
    }
}

