/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.dlm.DeleteManager;
import org.jasig.portal.layout.dlm.HandlerUtils;
import org.jasig.portal.layout.dlm.PositionManager;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TabColumnPrefsHandler {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(TabColumnPrefsHandler.class);

    public static void moveElement(Element compViewNode, Element oldCompViewParent, IPerson person) throws PortalException {
        Element plfParent;
        Element compViewParent;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("moving " + compViewNode.getAttribute("ID")));
        }
        if (oldCompViewParent != (compViewParent = (Element)compViewNode.getParentNode())) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("reparenting from " + oldCompViewParent.getAttribute("ID") + " to " + compViewParent.getAttribute("ID")));
            }
            if ((plfParent = HandlerUtils.getPLFNode((Element)oldCompViewParent, (IPerson)person, (boolean)false, (boolean)false)) != null) {
                PositionManager.updatePositionSet((Element)oldCompViewParent, (Element)plfParent, (IPerson)person);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"updating old parent's position set");
                }
            }
        }
        plfParent = HandlerUtils.getPLFNode((Element)compViewParent, (IPerson)person, (boolean)true, (boolean)false);
        if (compViewNode.getAttribute("ID").startsWith("u")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"ilf node being moved, only update new parent pos set");
            }
            PositionManager.updatePositionSet((Element)compViewParent, (Element)plfParent, (IPerson)person);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"plf node being moved, updating old parent's position set");
            }
            Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
            HandlerUtils.createOrMovePLFOwnedNode((Element)compViewNode, (Element)compViewParent, (boolean)false, (boolean)false, (Document)plf, (Element)plfParent, (IPerson)person);
        }
    }

    public static void deleteNode(Element compViewNode, Element compViewParent, IPerson person) throws PortalException {
        String ID = compViewNode.getAttribute("ID");
        if (ID.startsWith("u")) {
            DeleteManager.addDeleteDirective((Element)compViewNode, (String)ID, (IPerson)person);
        } else {
            Document plf = (Document)person.getAttribute("RDBMDistributedLayoutStore.PLF");
            Element node = plf.getElementById(ID);
            if (node == null) {
                return;
            }
            Element parent = (Element)node.getParentNode();
            if (parent == null) {
                return;
            }
            parent.removeChild(node);
        }
    }
}

