/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.providers.PersonEvaluatorFactory;
import org.jasig.portal.security.IPerson;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class AttributeEvaluator
extends Evaluator {
    public static final String RCS_ID = "@(#) $Header$";
    public static final int CONTAINS = 0;
    public static final int EQUALS = 1;
    public static final int STARTS_WITH = 2;
    public static final int ENDS_WITH = 3;
    public static final int EXISTS = 4;
    @Column(name="ATTRIBUTE_MODE")
    protected int mode = -1;
    @Column(name="ATTRIBUTE_NAME")
    protected String name = null;
    @Column(name="ATTRIBUTE_VALUE")
    protected String value = null;
    @Transient
    private final Log log = LogFactory.getLog(this.getClass());

    public AttributeEvaluator() {
    }

    public AttributeEvaluator(String name, String mode, String value) {
        if (mode.equals("equals")) {
            this.mode = 1;
            if (value == null) {
                throw new RuntimeException("Missing value attribute. For mode of 'equals' value must be defined.");
            }
        } else if (mode.equals("exists")) {
            this.mode = 4;
        } else if (mode.equals("contains")) {
            this.mode = 0;
            if (value == null || value.equals("")) {
                throw new RuntimeException("Missing or invalid value attribute. For mode of 'contains' value must be defined and not empty");
            }
        } else if (mode.equals("startsWith")) {
            this.mode = 2;
            if (value == null || value.equals("")) {
                throw new RuntimeException("Missing or invalid value attribute. For mode of 'startsWith' value must be defined and not empty");
            }
        } else if (mode.equals("endsWith")) {
            this.mode = 3;
            if (value == null || value.equals("")) {
                throw new RuntimeException("Missing or invalid value attribute. For mode of 'endsWith' value must be defined and not empty");
            }
        } else {
            throw new RuntimeException("Invalid mode attribute. Expected mode of 'contains', 'equals', 'startsWith', 'exists', or 'endsWith'");
        }
        this.name = name;
        this.value = value;
    }

    public boolean isApplicable(IPerson p) {
        String attrib = (String)p.getAttribute(this.name);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("mode=" + this.mode + ",attrib=" + attrib));
        }
        if (attrib == null && this.mode != 4) {
            return false;
        }
        if (this.mode == 1) {
            return attrib.equals(this.value);
        }
        if (this.mode == 4) {
            return attrib != null;
        }
        if (this.mode == 2) {
            return attrib.startsWith(this.value);
        }
        if (this.mode == 3) {
            return attrib.endsWith(this.value);
        }
        if (this.mode == 0) {
            return attrib.indexOf(this.value) != -1;
        }
        return false;
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        String mde = null;
        switch (this.mode) {
            case 0: {
                mde = "contains";
                break;
            }
            case 1: {
                mde = "equals";
                break;
            }
            case 2: {
                mde = "startsWith";
                break;
            }
            case 3: {
                mde = "endsWith";
                break;
            }
            case 4: {
                mde = "exists";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized mode constant:  " + this.mode);
            }
        }
        Element rslt = DocumentHelper.createElement((String)"attribute");
        rslt.addAttribute("name", this.name);
        rslt.addAttribute("mode", mde);
        rslt.addAttribute("value", this.value);
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return PersonEvaluatorFactory.class;
    }

    public String getSummary() {
        String relationship;
        switch (this.mode) {
            case 0: {
                relationship = "CONTAINS";
                break;
            }
            case 1: {
                relationship = "EQUALS";
                break;
            }
            case 2: {
                relationship = "STARTS WITH";
                break;
            }
            case 3: {
                relationship = "ENDS WITH";
                break;
            }
            case 4: {
                relationship = "EXISTS";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported MODE: " + this.mode);
            }
        }
        StringBuilder rslt = new StringBuilder();
        rslt.append("(");
        rslt.append("person attribute '").append(this.name).append("' ").append(relationship);
        if (this.mode != 4) {
            rslt.append(" '").append(this.value).append("'");
        }
        rslt.append(")");
        return rslt.toString();
    }
}

