/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.security.IPerson;
import org.w3c.dom.Node;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class GuestUserEvaluatorFactory
extends Evaluator
implements EvaluatorFactory {
    public static final String RCS_ID = "@(#) $Header$";
    @Transient
    private final Log log = LogFactory.getLog(this.getClass());

    public Evaluator getEvaluator(Node audience) {
        return this;
    }

    public boolean isApplicable(IPerson p) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Calling isApplicable():  username=" + p.getUserName() + ",isGuest=" + p.isGuest()));
        }
        return p.isGuest();
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Element rslt = null;
        QName q = new QName("audience", FragmentDefinition.NAMESPACE);
        rslt = DocumentHelper.createElement((QName)q);
        rslt.addAttribute("evaluatorFactory", this.getFactoryClass().getName());
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return this.getClass();
    }

    public String getSummary() {
        return "(GUEST)";
    }
}

