/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.providers.EvaluatorGroup;
import org.jasig.portal.layout.dlm.providers.Paren;
import org.jasig.portal.security.IPerson;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class Paren
extends EvaluatorGroup {
    public static final String RCS_ID = "@(#) $Header$";
    private static Log LOG = LogFactory.getLog(Paren.class);
    @Column(name="PAREN_TYPE")
    private Type type = null;

    public Paren() {
    }

    public Paren(Type t) {
        this.type = t;
    }

    public boolean isApplicable(IPerson toPerson) {
        boolean rslt = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" >>>> calling paren[" + this + ", op=" + this.type + "].isApplicable()"));
        }
        block0 : switch (1.$SwitchMap$org$jasig$portal$layout$dlm$providers$Paren$Type[this.type.ordinal()]) {
            case 1: {
                rslt = false;
                for (Evaluator v : this.evaluators) {
                    if (!v.isApplicable(toPerson)) continue;
                    rslt = true;
                    break block0;
                }
                break;
            }
            case 2: {
                rslt = true;
                for (Evaluator v : this.evaluators) {
                    if (v.isApplicable(toPerson)) continue;
                    rslt = false;
                    break block0;
                }
                break;
            }
            case 3: {
                rslt = false;
                for (Evaluator v : this.evaluators) {
                    if (!v.isApplicable(toPerson)) continue;
                    rslt = true;
                    break;
                }
                boolean bl = rslt = !rslt;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" ---- paren[" + this + ", op=" + this.type + "].isApplicable()=" + rslt));
        }
        return rslt;
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Element rslt = null;
        if (parent.getName().equals("fragment")) {
            QName q = new QName("audience", FragmentDefinition.NAMESPACE);
            rslt = DocumentHelper.createElement((QName)q);
            rslt.addAttribute("evaluatorFactory", this.getFactoryClass().getName());
        } else {
            rslt = DocumentHelper.createElement((String)"paren");
            rslt.addAttribute("mode", this.type.toString());
        }
        for (Evaluator v : this.evaluators) {
            v.toElement(rslt);
        }
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return ((Evaluator)this.evaluators.get(0)).getFactoryClass();
    }

    public String getSummary() {
        StringBuilder rslt = new StringBuilder();
        switch (1.$SwitchMap$org$jasig$portal$layout$dlm$providers$Paren$Type[this.type.ordinal()]) {
            case 1: 
            case 2: {
                String operator = this.type.equals((Object)Type.AND) ? " && " : " || ";
                for (int i = 0; i < this.evaluators.size(); ++i) {
                    if (i > 0) {
                        rslt.append(operator);
                    }
                    Evaluator ev = (Evaluator)this.evaluators.get(i);
                    rslt.append(ev.getSummary());
                }
                if (this.evaluators.size() <= 1) break;
                rslt.insert(0, "(").append(")");
                break;
            }
            case 3: {
                rslt.append("!");
                if (!this.evaluators.isEmpty()) {
                    rslt.append(((Evaluator)this.evaluators.get(0)).getSummary());
                    break;
                }
                rslt.append("()");
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized Type: " + this.type);
            }
        }
        return rslt.toString();
    }
}

