/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.layout.IProfileMapper;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.providers.ProfileEvaluatorFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.ApplicationContextLocator;
import org.jasig.portal.url.IPortalRequestUtils;
import org.springframework.context.ApplicationContext;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ProfileEvaluator
extends Evaluator {
    @Column(name="PROFILE_FNAME")
    protected String profileFname;

    public ProfileEvaluator() {
    }

    public ProfileEvaluator(String profileFname) {
        this.profileFname = profileFname;
    }

    public boolean isApplicable(IPerson person) {
        ApplicationContext applicationContext = ApplicationContextLocator.getApplicationContext();
        IPortalRequestUtils portalRequestUtils = (IPortalRequestUtils)applicationContext.getBean(IPortalRequestUtils.class);
        IProfileMapper profileMapper = (IProfileMapper)applicationContext.getBean("profileMapper", IProfileMapper.class);
        HttpServletRequest request = portalRequestUtils.getCurrentPortalRequest();
        String currentFname = profileMapper.getProfileFname(person, request);
        return this.profileFname.equals(currentFname);
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Element rslt = DocumentHelper.createElement((String)"profile");
        rslt.addAttribute("fname", this.profileFname);
        parent.add(rslt);
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return ProfileEvaluatorFactory.class;
    }

    public String getSummary() {
        return "(PROFILE IS '" + this.profileFname + "')";
    }
}

