/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.providers;

import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.fragment.subscribe.dao.IUserFragmentSubscriptionDao;
import org.jasig.portal.layout.dlm.Evaluator;
import org.jasig.portal.layout.dlm.EvaluatorFactory;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.providers.SubscribedTabEvaluatorFactory;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.UserFragmentSubscriptionDaoLocator;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SubscribedTabEvaluator
extends Evaluator {
    @Column(name="OWNER_ID")
    private final String ownerId;

    private SubscribedTabEvaluator() {
        this.ownerId = null;
    }

    public SubscribedTabEvaluator(String ownerId) {
        this.ownerId = ownerId;
    }

    public Class<? extends EvaluatorFactory> getFactoryClass() {
        return SubscribedTabEvaluatorFactory.class;
    }

    public boolean isApplicable(IPerson person) {
        IUserFragmentSubscriptionDao userFragmentInfoDao = UserFragmentSubscriptionDaoLocator.getUserIdentityStore();
        List fragments = userFragmentInfoDao.getUserFragmentInfo(person);
        for (IUserFragmentSubscription fragment : fragments) {
            if (!fragment.isActive() || !fragment.getFragmentOwner().equals(this.ownerId)) continue;
            return true;
        }
        return false;
    }

    public void toElement(Element parent) {
        if (parent == null) {
            String msg = "Argument 'parent' cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        Element rslt = null;
        QName q = new QName("audience", FragmentDefinition.NAMESPACE);
        rslt = DocumentHelper.createElement((QName)q);
        rslt.addAttribute("evaluatorFactory", this.getFactoryClass().getName());
        parent.add(rslt);
    }

    public String getSummary() {
        return "(OPT-IN USERS)";
    }
}

