/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.dlm.remoting.registry.ChannelBean;
import org.jasig.portal.layout.dlm.remoting.registry.ChannelCategoryBean;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlet.registry.IPortletCategoryRegistry;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.spring.spel.IPortalSpELService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/portletList"})
public class ChannelListController {
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IPortletCategoryRegistry portletCategoryRegistry;
    private IPersonManager personManager;
    private IPortalSpELService spELService;
    private ILocaleStore localeStore;
    private MessageSource messageSource;
    private static final String TYPE_SUBSCRIBE = "subscribe";
    private static final String TYPE_MANAGE = "manage";

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listChannels(WebRequest webRequest, HttpServletRequest request, @RequestParam(value="type", required=false) String type) {
        if (type == null || !type.equals(TYPE_MANAGE)) {
            type = TYPE_SUBSCRIBE;
        }
        IPerson user = this.personManager.getPerson(request);
        Map registry = this.getRegistry(webRequest, user, type);
        return new ModelAndView("jsonView", "registry", (Object)registry);
    }

    private Map<String, SortedSet<?>> getRegistry(WebRequest request, IPerson user, String type) {
        List allChannels = this.portletDefinitionRegistry.getAllPortletDefinitions();
        TreeMap registry = new TreeMap();
        TreeSet<ChannelCategoryBean> categories = new TreeSet<ChannelCategoryBean>();
        TreeSet<ChannelBean> channels = new TreeSet<ChannelBean>();
        Locale[] locales = this.localeStore.getUserLocales(user);
        LocaleManager localeManager = new LocaleManager(user, locales);
        Locale locale = localeManager.getLocales()[0];
        PortletCategory rootCategory = this.portletCategoryRegistry.getTopLevelPortletCategory();
        categories.add(this.addChildren(request, rootCategory, allChannels, user, type, locale));
        EntityIdentifier ei = user.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        if (type.equals(TYPE_MANAGE)) {
            for (IPortletDefinition channel : allChannels) {
                if (!ap.canManage(channel.getPortletDefinitionId().getStringId())) continue;
                channels.add(this.getChannel(channel, request, locale));
            }
        }
        registry.put("channels", channels);
        registry.put("categories", categories);
        return registry;
    }

    private ChannelCategoryBean addChildren(WebRequest request, PortletCategory category, List<IPortletDefinition> allChannels, IPerson user, String type, Locale locale) {
        ChannelCategoryBean categoryBean = new ChannelCategoryBean(category);
        categoryBean.setName(this.messageSource.getMessage(category.getName(), new Object[0], locale));
        Set portlets = this.portletCategoryRegistry.getChildPortlets(category);
        EntityIdentifier ei = user.getEntityIdentifier();
        IAuthorizationPrincipal ap = AuthorizationService.instance().newPrincipal(ei.getKey(), ei.getType());
        boolean isManage = type.equals(TYPE_MANAGE);
        for (IPortletDefinition channelDef : portlets) {
            if (isManage && ap.canManage(channelDef.getPortletDefinitionId().getStringId()) || !isManage && ap.canSubscribe(channelDef.getPortletDefinitionId().getStringId())) {
                ChannelBean channel = this.getChannel(channelDef, request, locale);
                categoryBean.addChannel(channel);
            }
            allChannels.remove(channelDef);
        }
        for (PortletCategory childCategory : this.portletCategoryRegistry.getChildCategories(category)) {
            ChannelCategoryBean childCategoryBean = this.addChildren(request, childCategory, allChannels, user, type, locale);
            categoryBean.addCategory(childCategoryBean);
        }
        return categoryBean;
    }

    private ChannelBean getChannel(IPortletDefinition definition, WebRequest request, Locale locale) {
        ChannelBean channel = new ChannelBean();
        channel.setId(definition.getPortletDefinitionId().getStringId());
        channel.setDescription(definition.getDescription(locale.toString()));
        channel.setFname(definition.getFName());
        channel.setName(definition.getName(locale.toString()));
        channel.setState(definition.getLifecycleState().toString());
        channel.setTitle(definition.getTitle(locale.toString()));
        channel.setTypeId(definition.getType().getId());
        IPortletDefinitionParameter iconParameter = definition.getParameter("iconUrl");
        if (iconParameter != null) {
            String iconUrl = this.spELService.parseString(iconParameter.getValue(), request);
            channel.setIconUrl(iconUrl);
        }
        return channel;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setPortletCategoryRegistry(IPortletCategoryRegistry portletCategoryRegistry) {
        this.portletCategoryRegistry = portletCategoryRegistry;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setPortalSpELProvider(IPortalSpELService spELProvider) {
        this.spELService = spELProvider;
    }

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

