/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.ConfigurationLoader;
import org.jasig.portal.layout.dlm.FragmentDefinition;
import org.jasig.portal.layout.dlm.remoting.FragmentListController;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.AdminEvaluator;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.xml.xpath.XPathOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/fragmentList"})
public class FragmentListController {
    private static final Sort DEFAULT_SORT = Sort.PRECEDENCE;
    private static final String CHANNEL_FNAME_XPATH = "//channel/@fname";
    private ConfigurationLoader dlmConfig;
    private IPersonManager personManager;
    private IUserLayoutStore userLayoutStore;
    private IPortletDefinitionRegistry portletRegistry;
    private XPathOperations xpathOperations;
    private final Log log = LogFactory.getLog(this.getClass());

    @Autowired
    public void setXpathOperations(XPathOperations xpathOperations) {
        this.xpathOperations = xpathOperations;
    }

    @Autowired
    public void setConfigurationLoader(ConfigurationLoader dlmConfig) {
        this.dlmConfig = dlmConfig;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    @Autowired
    public void setPortletRegistry(IPortletDefinitionRegistry portletRegistry) {
        this.portletRegistry = portletRegistry;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView listFragments(HttpServletRequest req) throws ServletException {
        IPerson user = this.personManager.getPerson(req);
        if (!AdminEvaluator.isAdmin((IPerson)user)) {
            throw new AuthorizationException("User " + user.getUserName() + " not an administrator.");
        }
        Map fragmentLayoutMap = null;
        if (this.userLayoutStore != null) {
            try {
                fragmentLayoutMap = this.userLayoutStore.getFragmentLayoutCopies();
            }
            catch (Exception e) {
                String msg = "Failed to access fragment layouts";
                this.log.error((Object)msg, (Throwable)e);
                throw new ServletException(msg, (Throwable)e);
            }
        }
        ArrayList<FragmentBean> fragments = new ArrayList<FragmentBean>();
        for (FragmentDefinition frag : this.dlmConfig.getFragments()) {
            Document layout = fragmentLayoutMap != null ? (Document)fragmentLayoutMap.get(frag.getOwnerId()) : null;
            ArrayList<String> portlets = null;
            if (layout != null) {
                portlets = new ArrayList<String>();
                NodeList channelFNames = (NodeList)this.xpathOperations.evaluate("//channel/@fname", (Object)layout, XPathConstants.NODESET);
                for (int i = 0; i < channelFNames.getLength(); ++i) {
                    String fname = channelFNames.item(i).getTextContent();
                    IPortletDefinition pDef = this.portletRegistry.getPortletDefinitionByFname(fname);
                    portlets.add(pDef.getTitle());
                }
            }
            fragments.add(FragmentBean.create((FragmentDefinition)frag, portlets));
        }
        Sort sort = DEFAULT_SORT;
        String sortParam = req.getParameter("sort");
        if (sortParam != null) {
            sort = Sort.valueOf((String)sortParam);
        }
        Collections.sort(fragments, sort.getComparator());
        return new ModelAndView("jsonView", "fragments", fragments);
    }
}

