/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.portlet.om.PortletCategory;
import org.jasig.portal.portlets.groupselector.EntityEnum;

public class JsonEntityBean
implements Serializable,
Comparable<JsonEntityBean> {
    private static final long serialVersionUID = 1L;
    public static final String ENTITY_CATEGORY = "category";
    public static final String ENTITY_CHANNEL = "channel";
    public static final String ENTITY_GROUP = "group";
    public static final String ENTITY_PERSON = "person";
    private EntityEnum entityType;
    private String id;
    private String name;
    private String creatorId;
    private String description;
    private String principalString;
    private String targetString;
    private List<JsonEntityBean> children = new ArrayList();
    private boolean childrenInitialized = false;

    public JsonEntityBean() {
    }

    public JsonEntityBean(PortletCategory category) {
        this.entityType = EntityEnum.CATEGORY;
        this.id = category.getId();
        this.name = category.getName();
        this.creatorId = category.getCreatorId();
        this.description = category.getDescription();
        this.targetString = category.getId();
    }

    public JsonEntityBean(IGroupMember groupMember, EntityEnum entityType) {
        this.entityType = entityType;
        this.id = groupMember.getKey();
        String prefix = "";
        switch (1.$SwitchMap$org$jasig$portal$portlets$groupselector$EntityEnum[entityType.ordinal()]) {
            case 1: {
                prefix = "PORTLET_ID.";
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported entityType:  " + entityType);
            }
        }
        this.targetString = prefix + groupMember.getKey();
    }

    public JsonEntityBean(IEntityGroup entityGroup, EntityEnum entityType) {
        this.entityType = entityType;
        this.id = entityGroup.getKey();
        this.name = entityGroup.getName();
        this.creatorId = entityGroup.getCreatorID();
        this.description = entityGroup.getDescription();
        this.targetString = entityGroup.getKey();
    }

    public EntityEnum getEntityType() {
        return this.entityType;
    }

    public String getEntityTypeAsString() {
        return this.entityType.toString().toUpperCase();
    }

    public void setEntityType(String entityType) {
        this.entityType = EntityEnum.getEntityEnum((String)entityType);
    }

    public void setEntityType(EntityEnum entityType) {
        this.entityType = entityType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrincipalString() {
        return this.principalString;
    }

    public void setPrincipalString(String principalString) {
        this.principalString = principalString;
    }

    public String getTargetString() {
        return this.targetString;
    }

    public void setTargetString(String targetString) {
        this.targetString = targetString;
    }

    public List<JsonEntityBean> getChildren() {
        return this.children;
    }

    public void setChildren(List<JsonEntityBean> children) {
        this.children = children;
    }

    public void addChild(JsonEntityBean child) {
        this.children.add(child);
    }

    public boolean isChildrenInitialized() {
        return this.childrenInitialized;
    }

    public void setChildrenInitialized(boolean childrenInitialized) {
        this.childrenInitialized = childrenInitialized;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childrenInitialized ? 1231 : 1237);
        result = 31 * result + (this.creatorId == null ? 0 : this.creatorId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonEntityBean other = (JsonEntityBean)obj;
        if (this.childrenInitialized != other.childrenInitialized) {
            return false;
        }
        if (this.creatorId == null ? other.creatorId != null : !this.creatorId.equals(other.creatorId)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals((Object)other.entityType)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(JsonEntityBean entity) {
        return new CompareToBuilder().append((Object)this.name, (Object)entity.getName()).append((Object)this.entityType, (Object)entity.getEntityType()).append((Object)this.creatorId, (Object)entity.getCreatorId()).append((Object)this.description, (Object)entity.getDescription()).append((Object)this.entityType, (Object)entity.getEntityType()).append((Object)this.id, (Object)entity.getId()).append((Object)this.principalString, (Object)this.getPrincipalString()).toComparison();
    }

    public String toString() {
        return "JsonEntityBean [entityType=" + this.entityType + ", id=" + this.id + ", name=" + this.name + ", creatorId=" + this.creatorId + ", description=" + this.description + ", principalString=" + this.principalString + "]";
    }
}

