/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.dlm.remoting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.PortalException;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.fragment.subscribe.IUserFragmentSubscription;
import org.jasig.portal.fragment.subscribe.dao.IUserFragmentSubscriptionDao;
import org.jasig.portal.layout.IStylesheetUserPreferencesService;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.dlm.DistributedUserLayout;
import org.jasig.portal.layout.dlm.UserPrefsHandler;
import org.jasig.portal.layout.node.IUserLayoutFolderDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutChannelDescription;
import org.jasig.portal.layout.node.UserLayoutFolderDescription;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.security.provider.RestrictedPerson;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Controller
@RequestMapping(value={"/layout"})
public class UpdatePreferencesServlet {
    private static final String TAB_GROUP_PARAMETER = "tabGroup";
    private static final String TAB_GROUP_DEFAULT = "DEFAULT_TABGROUP";
    protected final Log log = LogFactory.getLog(this.getClass());
    private IPortletDefinitionRegistry portletDefinitionRegistry;
    private IUserIdentityStore userIdentityStore;
    private IUserFragmentSubscriptionDao userFragmentInfoDao;
    private IUserInstanceManager userInstanceManager;
    private IStylesheetUserPreferencesService stylesheetUserPreferencesService;
    private IUserLayoutStore userLayoutStore;
    private MessageSource messageSource;
    protected static final String DEFAULT_TAB_NAME = "New Tab";

    @Autowired
    public void setUserLayoutStore(IUserLayoutStore userLayoutStore) {
        this.userLayoutStore = userLayoutStore;
    }

    @Autowired
    public void setStylesheetUserPreferencesService(IStylesheetUserPreferencesService stylesheetUserPreferencesService) {
        this.stylesheetUserPreferencesService = stylesheetUserPreferencesService;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    @Autowired
    public void setUserIdentityStore(IUserIdentityStore userStore) {
        this.userIdentityStore = userStore;
    }

    @Autowired
    public void setUserFragmentInfoDao(IUserFragmentSubscriptionDao userFragmentInfoDao) {
        this.userFragmentInfoDao = userFragmentInfoDao;
    }

    @Autowired
    public void setUserInstanceManager(IUserInstanceManager userInstanceManager) {
        this.userInstanceManager = userInstanceManager;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=removeElement"})
    public ModelAndView removeElement(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        try {
            String elementId = request.getParameter("elementID");
            if (elementId != null && elementId.startsWith("u") && ulm.getNode(elementId) instanceof UserLayoutFolderDescription) {
                this.removeSubscription(per, elementId, ulm);
            } else {
                ulm.deleteNode(elementId);
            }
            ulm.saveUserLayout();
            return new ModelAndView("jsonView", Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to remove element from layout", (Throwable)e);
            response.sendError(400);
            return null;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=subscribeToTab"})
    public ModelAndView subscribeToTab(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String fragmentOwnerName = request.getParameter("sourceID");
        if (StringUtils.isBlank((String)fragmentOwnerName)) {
            this.log.warn((Object)"Attempted to subscribe to tab with null owner ID");
            response.sendError(400);
            return null;
        }
        RestrictedPerson fragmentOwner = PersonFactory.createRestrictedPerson();
        fragmentOwner.setUserName(fragmentOwnerName);
        IUserFragmentSubscription userFragmentInfo = this.userFragmentInfoDao.getUserFragmentInfo(per, (IPerson)fragmentOwner);
        if (userFragmentInfo == null) {
            userFragmentInfo = this.userFragmentInfoDao.createUserFragmentInfo(per, (IPerson)fragmentOwner);
        } else {
            userFragmentInfo.setActive(true);
            this.userFragmentInfoDao.updateUserFragmentInfo(userFragmentInfo);
        }
        try {
            ulm.loadUserLayout(true);
            String destinationId = request.getParameter("elementID");
            int uid = this.userIdentityStore.getPortalUID((IPerson)fragmentOwner, false);
            DistributedUserLayout userLayout = this.userLayoutStore.getUserLayout(per, upm.getUserProfile());
            Document layoutDocument = userLayout.getLayout();
            StringBuilder expression = new StringBuilder("//folder[@type='root']/folder[starts-with(@ID,'").append("u").append(uid).append("')]");
            XPathFactory fac = XPathFactory.newInstance();
            XPath xpath = fac.newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(expression.toString(), layoutDocument, XPathConstants.NODESET);
            String sourceId = nodes.item(0).getAttributes().getNamedItem("ID").getTextContent();
            ulm.moveNode(sourceId, ulm.getParentId(destinationId), destinationId);
            ulm.saveUserLayout();
            return new ModelAndView("jsonView", Collections.singletonMap("tabId", sourceId));
        }
        catch (Exception e) {
            this.log.warn((Object)("Error subscribing to fragment owned by " + fragmentOwnerName), (Throwable)e);
            response.sendError(400);
            return null;
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=movePortlet"})
    public ModelAndView movePortlet(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String sourceId = request.getParameter("sourceID");
        String method = request.getParameter("method");
        String destinationId = request.getParameter("elementID");
        if (this.isTab(ulm, destinationId)) {
            Enumeration columns = ulm.getChildIds(destinationId);
            if (columns.hasMoreElements()) {
                ulm.moveNode(sourceId, (String)columns.nextElement(), null);
            } else {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription col = ulm.addNode((IUserLayoutNodeDescription)newColumn, destinationId, null);
                ulm.moveNode(sourceId, col.getId(), null);
            }
        } else if (ulm.getRootFolderId().equals(ulm.getParentId(ulm.getParentId(destinationId)))) {
            ulm.moveNode(sourceId, destinationId, null);
        } else {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationId;
            }
            ulm.moveNode(sourceId, ulm.getParentId(destinationId), siblingId);
        }
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        return new ModelAndView("jsonView", Collections.EMPTY_MAP);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=changeColumns"})
    public ModelAndView changeColumns(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tabId") String tabId, @RequestParam(value="widths[]") String[] widths, @RequestParam(value="deleted[]", required=false) String[] deleted, @RequestParam(value="acceptor", required=false) String acceptor) throws IOException, PortalException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        int newColumnCount = widths.length;
        Enumeration columns = ulm.getChildIds(tabId);
        ArrayList columnList = new ArrayList();
        while (columns.hasMoreElements()) {
            columnList.add(columns.nextElement());
        }
        int oldColumnCount = columnList.size();
        HashMap model = new HashMap();
        if (newColumnCount > oldColumnCount) {
            ArrayList<String> newColumnIds = new ArrayList<String>();
            for (int i = columnList.size(); i < newColumnCount; ++i) {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription node = ulm.addNode((IUserLayoutNodeDescription)newColumn, tabId, null);
                newColumnIds.add(node.getId());
                model.put("newColumnIds", newColumnIds);
                columnList.add(node.getId());
            }
        } else if (deleted != null && deleted.length > 0) {
            if (columnList.size() != widths.length + deleted.length) {
                // empty if block
            }
            for (String columnId : deleted) {
                Enumeration channels = ulm.getChildIds(columnId);
                while (channels.hasMoreElements()) {
                    ulm.addNode(ulm.getNode((String)channels.nextElement()), acceptor, null);
                }
                ulm.deleteNode(columnId);
                columnList.remove(columnId);
            }
        }
        int count = 0;
        for (String columnId : columnList) {
            this.stylesheetUserPreferencesService.setLayoutAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, columnId, "width", widths[count] + "%");
            try {
                Element folder = ulm.getUserLayoutDOM().getElementById(columnId);
                UserPrefsHandler.setUserPreference((Element)folder, (String)"width", (IPerson)per);
            }
            catch (Exception e) {
                this.log.error((Object)"Error saving new column widths", (Throwable)e);
            }
            ++count;
        }
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        return new ModelAndView("jsonView", model);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=moveTab"})
    public ModelAndView moveTab(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String destinationId = request.getParameter("elementID");
        String sourceId = request.getParameter("sourceID");
        String method = request.getParameter("method");
        String siblingId = null;
        if (method.equals("insertBefore")) {
            siblingId = destinationId;
        }
        ulm.moveNode(sourceId, ulm.getParentId(destinationId), siblingId);
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to move tab in user layout", (Throwable)e);
            response.sendError(400);
            return null;
        }
        return new ModelAndView("jsonView", Collections.EMPTY_MAP);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=addPortlet"})
    public ModelAndView addPortlet(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String destinationId = request.getParameter("elementID");
        String sourceId = request.getParameter("channelID");
        String method = request.getParameter("position");
        IPortletDefinition definition = this.portletDefinitionRegistry.getPortletDefinition(sourceId);
        UserLayoutChannelDescription channel = new UserLayoutChannelDescription(definition);
        IUserLayoutNodeDescription node = null;
        if (this.isTab(ulm, destinationId)) {
            Enumeration columns = ulm.getChildIds(destinationId);
            if (columns.hasMoreElements()) {
                while (columns.hasMoreElements() && (node = ulm.addNode((IUserLayoutNodeDescription)channel, (String)columns.nextElement(), null)) == null) {
                }
            } else {
                UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
                newColumn.setName("Column");
                newColumn.setId("tbd");
                newColumn.setFolderType(0);
                newColumn.setHidden(false);
                newColumn.setUnremovable(false);
                newColumn.setImmutable(false);
                IUserLayoutNodeDescription col = ulm.addNode((IUserLayoutNodeDescription)newColumn, destinationId, null);
                node = ulm.addNode((IUserLayoutNodeDescription)channel, col.getId(), null);
            }
        } else if (this.isColumn(ulm, destinationId)) {
            node = ulm.addNode((IUserLayoutNodeDescription)channel, destinationId, null);
        } else {
            String siblingId = null;
            if (method.equals("insertBefore")) {
                siblingId = destinationId;
            }
            node = ulm.addNode((IUserLayoutNodeDescription)channel, ulm.getParentId(destinationId), siblingId);
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        if (node == null) {
            return new ModelAndView("jsonView", Collections.singletonMap("error", this.getMessage("error.add.portlet.in.tab", "Can''t add a new channel", locale)));
        }
        String nodeId = node.getId();
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
            return new ModelAndView("jsonView", Collections.singletonMap("error", this.getMessage("error.persisting.layout.change", "Can''t add a new channel", locale)));
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("response", this.getMessage("success.add.portlet", "Added a new channel", locale));
        model.put("newNodeId", nodeId);
        return new ModelAndView("jsonView", model);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=chooseSkin"})
    public ModelAndView chooseSkin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String skinName = request.getParameter("skinName");
        this.stylesheetUserPreferencesService.setStylesheetParameter(request, IStylesheetUserPreferencesService.PreferencesScope.THEME, "skin", skinName);
        return new ModelAndView("jsonView", Collections.EMPTY_MAP);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=addTab"})
    public ModelAndView addTab(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="widths[]") String[] widths) throws IOException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String id = "tbd";
        String tabName = request.getParameter("tabName");
        if (StringUtils.isBlank((String)tabName)) {
            tabName = DEFAULT_TAB_NAME;
        }
        UserLayoutFolderDescription newTab = new UserLayoutFolderDescription();
        newTab.setName(tabName);
        newTab.setId(id);
        newTab.setFolderType(0);
        newTab.setHidden(false);
        newTab.setUnremovable(false);
        newTab.setImmutable(false);
        ulm.addNode((IUserLayoutNodeDescription)newTab, ulm.getRootFolderId(), null);
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        String tabId = newTab.getId();
        for (String width : widths) {
            UserLayoutFolderDescription newColumn = new UserLayoutFolderDescription();
            newColumn.setName("Column");
            newColumn.setId("tbd");
            newColumn.setFolderType(0);
            newColumn.setHidden(false);
            newColumn.setUnremovable(false);
            newColumn.setImmutable(false);
            ulm.addNode((IUserLayoutNodeDescription)newColumn, tabId, null);
            this.stylesheetUserPreferencesService.setLayoutAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, newColumn.getId(), "width", width + "%");
            try {
                Element folder = ulm.getUserLayoutDOM().getElementById(newColumn.getId());
                UserPrefsHandler.setUserPreference((Element)folder, (String)"width", (IPerson)per);
            }
            catch (Exception e) {
                this.log.error((Object)"Error saving new column widths", (Throwable)e);
            }
        }
        if (request.getParameter(TAB_GROUP_PARAMETER) != null) {
            String tabGroup = request.getParameter(TAB_GROUP_PARAMETER).trim();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("tabGroup=" + tabGroup));
            }
            if (!TAB_GROUP_DEFAULT.equals(tabGroup) && tabGroup.length() != 0) {
                this.stylesheetUserPreferencesService.setLayoutAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, tabId, TAB_GROUP_PARAMETER, tabGroup);
            }
        }
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        return new ModelAndView("jsonView", Collections.singletonMap("tabId", tabId));
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=renameTab"})
    public ModelAndView renameTab(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        IPerson per = this.getPerson(ui, response);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        String tabId = request.getParameter("tabId");
        IUserLayoutFolderDescription tab = (IUserLayoutFolderDescription)ulm.getNode(tabId);
        String tabName = request.getParameter("tabName");
        if (!ulm.canUpdateNode((IUserLayoutNodeDescription)tab)) {
            this.log.warn((Object)"Attempting to rename an immutable tab");
            response.sendError(400);
            return null;
        }
        tab.setName(StringUtils.isBlank((String)tabName) ? DEFAULT_TAB_NAME : tabName);
        boolean updated = ulm.updateNode((IUserLayoutNodeDescription)tab);
        if (updated) {
            try {
                ulm.saveUserLayout();
            }
            catch (Exception e) {
                this.log.warn((Object)"Error saving layout", (Throwable)e);
            }
            this.stylesheetUserPreferencesService.setLayoutAttribute(request, IStylesheetUserPreferencesService.PreferencesScope.STRUCTURE, tabId, "name", tabName);
        }
        Map<String, String> model = Collections.singletonMap("message", "saved new tab name");
        return new ModelAndView("jsonView", model);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"action=updatePermissions"})
    public ModelAndView updatePermissions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String canAddChildren;
        String editable;
        String movable;
        String elementId;
        IUserInstance ui = this.userInstanceManager.getUserInstance(request);
        UserPreferencesManager upm = (UserPreferencesManager)ui.getPreferencesManager();
        IUserLayoutManager ulm = upm.getUserLayoutManager();
        IUserLayoutNodeDescription node = ulm.getNode(elementId = request.getParameter("elementID"));
        if (node == null) {
            this.log.warn((Object)"Failed to locate node for permissions update");
            response.sendError(400);
            return null;
        }
        String deletable = request.getParameter("deletable");
        if (!StringUtils.isBlank((String)deletable)) {
            node.setDeleteAllowed(Boolean.valueOf(deletable).booleanValue());
        }
        if (!StringUtils.isBlank((String)(movable = request.getParameter("movable")))) {
            node.setMoveAllowed(Boolean.valueOf(movable).booleanValue());
        }
        if (!StringUtils.isBlank((String)(editable = request.getParameter("editable")))) {
            node.setEditAllowed(Boolean.valueOf(editable).booleanValue());
        }
        if (!StringUtils.isBlank((String)(canAddChildren = request.getParameter("addChildAllowed")))) {
            node.setAddChildAllowed(Boolean.valueOf(canAddChildren).booleanValue());
        }
        ulm.updateNode(node);
        try {
            ulm.saveUserLayout();
        }
        catch (Exception e) {
            this.log.warn((Object)"Error saving layout", (Throwable)e);
        }
        return new ModelAndView("jsonView", Collections.EMPTY_MAP);
    }

    protected void removeSubscription(IPerson per, String elementId, IUserLayoutManager ulm) {
        String userIdString = StringUtils.substringBetween((String)elementId, (String)"u", (String)"l");
        int userId = NumberUtils.toInt((String)userIdString, (int)0);
        RestrictedPerson fragmentOwner = PersonFactory.createRestrictedPerson();
        fragmentOwner.setID(userId);
        fragmentOwner.setUserName(this.userIdentityStore.getPortalUserName(userId));
        IUserFragmentSubscription subscription = this.userFragmentInfoDao.getUserFragmentInfo(per, (IPerson)fragmentOwner);
        if (subscription != null) {
            this.userFragmentInfoDao.deleteUserFragmentInfo(subscription);
            ulm.loadUserLayout(true);
        } else {
            ulm.deleteNode(elementId);
        }
    }

    protected boolean isTab(IUserLayoutManager ulm, String folderId) throws PortalException {
        return ulm.getRootFolderId().equals(ulm.getParentId(folderId));
    }

    protected IPerson getPerson(IUserInstance ui, HttpServletResponse response) throws IOException {
        IPerson per = ui.getPerson();
        if (per.isGuest()) {
            response.sendError(401);
            return null;
        }
        return per;
    }

    protected String getMessage(String key, String defaultName, Locale locale) {
        return this.messageSource.getMessage(key, new Object[0], defaultName, locale);
    }

    protected boolean isColumn(IUserLayoutManager ulm, String folderId) throws PortalException {
        return this.isTab(ulm, ulm.getParentId(folderId));
    }
}

