/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.layout.node.UserLayoutNodeDescription;
import org.jasig.portal.portlet.om.IPortletDefinition;
import org.jasig.portal.portlet.om.IPortletDefinitionParameter;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.spring.locator.PortletDefinitionRegistryLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserLayoutChannelDescription
extends UserLayoutNodeDescription
implements IUserLayoutChannelDescription {
    private static final Log log = LogFactory.getLog(UserLayoutChannelDescription.class);
    Hashtable parameters = new Hashtable();
    String title = null;
    String description = null;
    String className = null;
    String channelPublishId = null;
    String channelTypeId = null;
    String functionalName = null;
    long timeout = -1L;
    boolean editable = false;
    boolean hasHelp = false;
    boolean hasAbout = false;
    boolean isSecure = false;

    public UserLayoutChannelDescription() {
    }

    public UserLayoutChannelDescription(IUserLayoutChannelDescription d) {
        this();
        this.title = d.getTitle();
        this.name = d.getName();
        this.description = d.getDescription();
        this.setClassName(d.getClassName());
        this.channelPublishId = d.getChannelPublishId();
        this.channelTypeId = d.getChannelTypeId();
        this.functionalName = d.getFunctionalName();
        this.timeout = d.getTimeout();
        this.editable = d.isEditable();
        this.hasHelp = d.hasHelp();
        this.hasAbout = d.hasAbout();
        Enumeration enum1 = d.getParameterNames();
        while (enum1.hasMoreElements()) {
            String pName = (String)enum1.nextElement();
            this.setParameterValue(pName, d.getParameterValue(pName));
        }
    }

    public UserLayoutChannelDescription(IPortletDefinition definition) {
        this();
        this.title = definition.getTitle();
        this.name = definition.getName();
        this.name = definition.getName();
        this.description = definition.getDescription();
        this.channelPublishId = String.valueOf(definition.getPortletDefinitionId().getStringId());
        this.channelTypeId = String.valueOf(definition.getType().getId());
        this.functionalName = definition.getFName();
        this.timeout = definition.getTimeout();
        for (IPortletDefinitionParameter param : definition.getParameters()) {
            this.setParameterValue(param.getName(), param.getValue());
        }
    }

    public UserLayoutChannelDescription(Element xmlNode) throws PortalException {
        super(xmlNode);
        if (!xmlNode.getNodeName().equals("channel")) {
            throw new PortalException("Given XML Element is not a channel!");
        }
        this.setTitle(xmlNode.getAttribute("title"));
        this.setDescription(xmlNode.getAttribute("description"));
        this.setClassName(xmlNode.getAttribute("class"));
        this.setChannelPublishId(xmlNode.getAttribute("chanID"));
        this.setChannelTypeId(xmlNode.getAttribute("typeID"));
        this.setFunctionalName(xmlNode.getAttribute("fname"));
        this.setTimeout(Long.parseLong(xmlNode.getAttribute("timeout")));
        this.setEditable(Boolean.valueOf(xmlNode.getAttribute("editable")).booleanValue());
        this.setHasHelp(Boolean.valueOf(xmlNode.getAttribute("hasHelp")).booleanValue());
        this.setHasAbout(Boolean.valueOf(xmlNode.getAttribute("hasAbout")).booleanValue());
        this.setIsSecure(Boolean.valueOf(xmlNode.getAttribute("secure")).booleanValue());
        for (Node n = xmlNode.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element e;
            if (n.getNodeType() != 1 || !(e = (Element)n).getNodeName().equals("parameter")) continue;
            String pName = e.getAttribute("name");
            String pValue = e.getAttribute("value");
            Boolean canOverride = new Boolean(false);
            String str_override = e.getAttribute("override");
            if (str_override != null && str_override.equals("yes")) {
                canOverride = new Boolean(true);
            }
            if (pName == null || pValue == null) continue;
            this.setParameterValue(pName, pValue);
        }
    }

    public boolean hasAbout() {
        return this.hasAbout;
    }

    public void setHasAbout(boolean v) {
        this.hasAbout = v;
    }

    public boolean hasHelp() {
        return this.hasHelp;
    }

    public void setHasHelp(boolean v) {
        this.hasHelp = v;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean v) {
        this.editable = v;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long v) {
        this.timeout = v;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setIsSecure(boolean secure) {
        this.isSecure = secure;
    }

    public boolean isPortlet() {
        return true;
    }

    public String getFunctionalName() {
        return this.functionalName;
    }

    public void setFunctionalName(String v) {
        this.functionalName = v;
    }

    public String getChannelSubscribeId() {
        return super.getId();
    }

    public void setChannelSubscribeId(String v) {
        super.setId(v);
    }

    public String getChannelTypeId() {
        return this.channelTypeId;
    }

    public void setChannelTypeId(String v) {
        this.channelTypeId = v;
    }

    public String getChannelPublishId() {
        return this.channelPublishId;
    }

    public void setChannelPublishId(String v) {
        this.channelPublishId = v;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) {
        this.className = v;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String setParameterValue(String parameterName, String parameterValue) {
        if (parameterValue == null) {
            return null;
        }
        return this.parameters.put(parameterName, parameterValue);
    }

    public void resetParameter(String parameterName) throws PortalException {
        try {
            IPortletDefinitionRegistry registry = PortletDefinitionRegistryLocator.getPortletDefinitionRegistry();
            int pubId = Integer.parseInt(this.getChannelPublishId());
            IPortletDefinition def = registry.getPortletDefinition(this.getChannelPublishId());
            IPortletDefinitionParameter parm = def.getParameter(parameterName);
            if (parm == null) {
                this.parameters.remove(parameterName);
            }
        }
        catch (Exception e) {
            throw new PortalException("Unable to reset parameter [" + parameterName + "] for channel [" + this.getTitle() + "].", (Throwable)e);
        }
    }

    public String getParameterValue(String parameterName) {
        return (String)this.parameters.get(parameterName);
    }

    public Collection getParameterValues() {
        return this.parameters.values();
    }

    public int numberOfParameters() {
        return this.parameters.size();
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public String remove(String parameterName) {
        return (String)this.parameters.remove(parameterName);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public boolean containsParameter(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }

    public Element getXML(Document root) {
        Element node = root.createElement("channel");
        this.addNodeAttributes(node);
        this.addParameterChildren(node, root);
        return node;
    }

    public void addParameterChildren(Element node, Document root) {
        Enumeration enum1 = this.getParameterNames();
        while (enum1.hasMoreElements()) {
            Element pElement = root.createElement("parameter");
            String pName = (String)enum1.nextElement();
            pElement.setAttribute("name", pName);
            pElement.setAttribute("value", this.getParameterValue(pName));
            node.appendChild(pElement);
        }
    }

    public void addNodeAttributes(Element node) {
        super.addNodeAttributes(node);
        node.setAttribute("title", this.getTitle());
        node.setAttribute("name", this.getName());
        node.setAttribute("description", this.getDescription());
        node.setAttribute("class", this.getClassName());
        node.setAttribute("chanID", this.getChannelPublishId());
        node.setAttribute("typeID", this.getChannelTypeId());
        node.setAttribute("fname", this.getFunctionalName());
        node.setAttribute("timeout", Long.toString(this.getTimeout()));
        node.setAttribute("editable", new Boolean(this.isEditable()).toString());
        node.setAttribute("hasHelp", new Boolean(this.hasHelp()).toString());
        node.setAttribute("hasAbout", new Boolean(this.hasAbout()).toString());
        node.setAttribute("secure", new Boolean(this.isSecure()).toString());
        node.setAttribute("isPortlet", Boolean.valueOf(this.isPortlet()).toString());
    }

    public IUserLayoutNodeDescription.LayoutNodeType getType() {
        return IUserLayoutNodeDescription.LayoutNodeType.PORTLET;
    }

    public String toString() {
        return "[" + this.channelPublishId + "," + this.title + "]";
    }
}

