/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.layout.simple;

import com.google.common.cache.Cache;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.IUserProfile;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.ILocaleStore;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.layout.IUserLayoutStore;
import org.jasig.portal.layout.LayoutStructure;
import org.jasig.portal.layout.dao.IStylesheetDescriptorDao;
import org.jasig.portal.portlet.registry.IPortletDefinitionRegistry;
import org.jasig.portal.rdbm.DatabaseMetaDataImpl;
import org.jasig.portal.rdbm.IDatabaseMetadata;
import org.jasig.portal.rdbm.IJoinQueryString;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.spring.locator.CounterStoreLocator;
import org.jasig.portal.utils.ICounterStore;
import org.jasig.portal.utils.Tuple;
import org.jasig.portal.utils.threading.SingletonDoubleCheckedCreator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RDBMUserLayoutStore
implements IUserLayoutStore,
InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static String PROFILE_TABLE = "UP_USER_PROFILE";
    protected static final String DEFAULT_LAYOUT_FNAME = "default";
    protected static final String channelPrefix = "n";
    protected static final String folderPrefix = "s";
    protected TransactionOperations transactionOperations;
    protected TransactionOperations nextStructTransactionOperations;
    protected JdbcOperations jdbcOperations;
    private ILocaleStore localeStore;
    protected IDatabaseMetadata databaseMetadata;
    protected IPersonManager personManager;
    protected ICounterStore counterStore;
    protected IPortletDefinitionRegistry portletDefinitionRegistry;
    protected IStylesheetDescriptorDao stylesheetDescriptorDao;
    protected SQLExceptionTranslator exceptionTranslator;
    protected static final boolean localeAware = LocaleManager.isLocaleAware();
    private final SingletonDoubleCheckedCreator<IPerson> systemPersonCreator = new /* Unavailable Anonymous Inner Class!! */;
    private final ThreadLocal<Cache<Tuple<String, String>, UserProfile>> profileCacheHolder = new ThreadLocal();

    @Autowired
    public void setLocaleStore(ILocaleStore localeStore) {
        this.localeStore = localeStore;
    }

    @Autowired
    public void setStylesheetDescriptorDao(IStylesheetDescriptorDao stylesheetDescriptorDao) {
        this.stylesheetDescriptorDao = stylesheetDescriptorDao;
    }

    @Autowired
    public void setPlatformTransactionManager(@Qualifier(value="PortalDb") PlatformTransactionManager platformTransactionManager) {
        this.transactionOperations = new TransactionTemplate(platformTransactionManager);
        DefaultTransactionDefinition nextStructTransactionDefinition = new DefaultTransactionDefinition();
        nextStructTransactionDefinition.setPropagationBehavior(3);
        this.nextStructTransactionOperations = new TransactionTemplate(platformTransactionManager, (TransactionDefinition)nextStructTransactionDefinition);
    }

    @Resource(name="PortalDb")
    public void setDataSource(DataSource dataSource) {
        this.jdbcOperations = new JdbcTemplate(dataSource);
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
    }

    @Autowired
    public void setDatabaseMetadata(IDatabaseMetadata databaseMetadata) {
        this.databaseMetadata = databaseMetadata;
    }

    @Autowired
    public void setPersonManager(IPersonManager personManager) {
        this.personManager = personManager;
    }

    @Autowired
    public void setCounterStore(ICounterStore counterStore) {
        this.counterStore = counterStore;
    }

    @Autowired
    public void setPortletDefinitionRegistry(IPortletDefinitionRegistry portletDefinitionRegistry) {
        this.portletDefinitionRegistry = portletDefinitionRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.databaseMetadata.supportsOuterJoins()) {
            IJoinQueryString joinQuery = this.databaseMetadata.getJoinQuery();
            if (joinQuery instanceof DatabaseMetaDataImpl.JdbcDb) {
                joinQuery.addQuery("layout", "{oj UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID} WHERE");
                joinQuery.addQuery("ss_struct", "{oj UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID} WHERE");
                joinQuery.addQuery("ss_theme", "{oj UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID} WHERE");
            } else if (joinQuery instanceof DatabaseMetaDataImpl.PostgreSQLDb) {
                joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS LEFT OUTER JOIN UP_LAYOUT_PARAM USP ON ULS.USER_ID = USP.USER_ID AND ULS.STRUCT_ID = USP.STRUCT_ID WHERE");
                joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS LEFT OUTER JOIN UP_SS_STRUCT_PAR USP ON USS.SS_ID=USP.SS_ID WHERE");
                joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS LEFT OUTER JOIN UP_SS_THEME_PARM UTP ON UTS.SS_ID=UTP.SS_ID WHERE");
            } else if (joinQuery instanceof DatabaseMetaDataImpl.OracleDb) {
                joinQuery.addQuery("layout", "UP_LAYOUT_STRUCT ULS, UP_LAYOUT_PARAM USP WHERE ULS.STRUCT_ID = USP.STRUCT_ID(+) AND ULS.USER_ID = USP.USER_ID(+) AND");
                joinQuery.addQuery("ss_struct", "UP_SS_STRUCT USS, UP_SS_STRUCT_PAR USP WHERE USS.SS_ID=USP.SS_ID(+) AND");
                joinQuery.addQuery("ss_theme", "UP_SS_THEME UTS, UP_SS_THEME_PARM UTP WHERE UTS.SS_ID=UTP.SS_ID(+) AND");
            } else {
                throw new RuntimeException("Unknown database driver");
            }
        }
    }

    private final IPerson getSystemUser() {
        return (IPerson)this.systemPersonCreator.get(new Object[0]);
    }

    public UserProfile addUserProfile(IPerson person, IUserProfile profile) {
        int userId = person.getID();
        return (UserProfile)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private int getNextKey() {
        return CounterStoreLocator.getCounterStore().getNextId(PROFILE_TABLE);
    }

    protected static boolean channelApproved(Date approvedDate) {
        Date rightNow = new Date();
        return approvedDate != null && rightNow.after(approvedDate);
    }

    protected final void createLayout(HashMap layoutStructure, Document doc, Element root, int structId) throws SQLException {
        while (structId != 0) {
            LayoutStructure ls = (LayoutStructure)layoutStructure.get(new Integer(structId));
            Element structure = this.getStructure(doc, ls);
            root.appendChild(structure);
            String id = structure.getAttribute("ID");
            if (id != null && !id.equals("")) {
                structure.setIdAttribute("ID", true);
            }
            this.createLayout(layoutStructure, doc, structure, ls.getChildId());
            structId = ls.getNextId();
        }
    }

    protected static final boolean xmlBool(String value) {
        return value != null && value.equals("true");
    }

    public void deleteUserProfile(IPerson person, int profileId) {
        int userId = person.getID();
        this.deleteUserProfile(userId, profileId);
    }

    private void deleteUserProfile(int userId, int profileId) {
        this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final void dumpDoc(Node node, String indent) {
        if (node == null) {
            return;
        }
        if (node instanceof Element) {
            System.err.print(indent + "element: tag=" + ((Element)node).getTagName() + " ");
        } else if (node instanceof Document) {
            System.err.print("document:");
        } else {
            System.err.print(indent + "node:");
        }
        System.err.println("name=" + node.getNodeName() + " value=" + node.getNodeValue());
        NamedNodeMap nm = node.getAttributes();
        if (nm != null) {
            for (int i = 0; i < nm.getLength(); ++i) {
                System.err.println(indent + " " + nm.item(i).getNodeName() + ": '" + nm.item(i).getNodeValue() + "'");
            }
            System.err.println(indent + "--");
        }
        if (node.hasChildNodes()) {
            RDBMUserLayoutStore.dumpDoc((Node)node.getFirstChild(), (String)(indent + "   "));
        }
        RDBMUserLayoutStore.dumpDoc((Node)node.getNextSibling(), (String)indent);
    }

    public String generateNewChannelSubscribeId(IPerson person) {
        return this.getNextStructId(person, "n");
    }

    public String generateNewFolderId(IPerson person) {
        return this.getNextStructId(person, "s");
    }

    protected String getNextStructId(IPerson person, String prefix) {
        int userId = person.getID();
        return (String)this.nextStructTransactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected String getStructId(int structId, int chanId) {
        if (chanId == 0) {
            return "s" + structId;
        }
        return "n" + structId;
    }

    private String getName(Document descr) {
        NodeList names = descr.getElementsByTagName("name");
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RDBMUserLayoutStore::getName() : no \"name\" element was found under the \"stylesheetdescription\" node!");
        }
        return null;
    }

    private String getRootElementTextValue(Document descr, String elementName) {
        NodeList names = descr.getElementsByTagName(elementName);
        Node name = null;
        for (int i = names.getLength() - 1; i >= 0 && !(name = names.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            name = null;
        }
        if (name != null) {
            return this.getTextChildNodeValue(name);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("RDBMUserLayoutStore::getRootElementTextValue() : no \"" + elementName + "\" element was found under the \"stylesheetdescription\" node!"));
        }
        return null;
    }

    private String getDescription(Document descr) {
        NodeList descriptions = descr.getElementsByTagName("description");
        Node description = null;
        for (int i = descriptions.getLength() - 1; i >= 0 && !(description = descriptions.item(i)).getParentNode().getNodeName().equals("stylesheetdescription"); --i) {
            description = null;
        }
        if (description != null) {
            return this.getTextChildNodeValue(description);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"RDBMUserLayoutStore::getDescription() : no \"description\" element was found under the \"stylesheetdescription\" node!");
        }
        return null;
    }

    private Vector getVectorOfSimpleTextElementValues(Document descr, String elementName) {
        Vector<String> v = new Vector<String>();
        Element stylesheetdescriptionElement = (Element)descr.getElementsByTagName("stylesheetdescription").item(0);
        if (stylesheetdescriptionElement == null) {
            this.log.error((Object)"Could not obtain <stylesheetdescription> element");
            return null;
        }
        NodeList elements = stylesheetdescriptionElement.getElementsByTagName(elementName);
        for (int i = elements.getLength() - 1; i >= 0; --i) {
            v.add(this.getTextChildNodeValue(elements.item(i)));
        }
        return v;
    }

    private String getTextChildNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue();
        }
        return null;
    }

    private String getUserBrowserMapping(IPerson person, String userAgentArg) {
        int userId = person.getID();
        return (String)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Document getPersonalUserLayout(IPerson person, IUserProfile profile) {
        LocaleManager localeManager = profile.getLocaleManager();
        return (Document)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public IUserProfile getUserProfileById(IPerson person, int profileId) {
        int userId = person.getID();
        return (IUserProfile)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setProfileImportExportCache(Cache<Tuple<String, String>, UserProfile> profileCache) {
        if (profileCache == null) {
            this.profileCacheHolder.remove();
        } else {
            this.profileCacheHolder.set(profileCache);
        }
    }

    private Cache<Tuple<String, String>, UserProfile> getProfileImportExportCache() {
        return (Cache)this.profileCacheHolder.get();
    }

    public UserProfile getUserProfileByFname(IPerson person, String profileFname) {
        UserProfile profile;
        Tuple key = null;
        Cache profileCache = this.getProfileImportExportCache();
        if (profileCache != null && (profile = (UserProfile)profileCache.getIfPresent((Object)(key = new Tuple((Object)person.getUserName(), (Object)profileFname)))) != null) {
            return profile;
        }
        this.log.debug((Object)("Getting profile " + profileFname + " for user " + person.getID()));
        int userId = person.getID();
        UserProfile userProfile = (UserProfile)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (profileCache != null && key != null) {
            profileCache.put((Object)key, (Object)userProfile);
        }
        return userProfile;
    }

    public Hashtable getUserProfileList(IPerson person) {
        int userId = person.getID();
        return (Hashtable)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Element getStructure(Document var1, LayoutStructure var2);

    protected abstract int saveStructure(Node var1, PreparedStatement var2, PreparedStatement var3) throws SQLException;

    public void setUserBrowserMapping(IPerson person, String userAgentArg, int profileId) {
        int userId = person.getID();
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setUserLayout(IPerson person, IUserProfile profile, Document layoutXML, boolean channelsAdded) {
        long startTime = System.currentTimeMillis();
        int userId = person.getID();
        int profileId = profile.getProfileId();
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
        if (this.log.isDebugEnabled()) {
            long stopTime = System.currentTimeMillis();
            this.log.debug((Object)("RDBMUserLayoutStore::setUserLayout(): Layout document for user " + userId + " took " + (stopTime - startTime) + " milliseconds to save"));
        }
    }

    public void updateUserProfile(IPerson person, IUserProfile profile) {
        int userId = person.getID();
        this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setSystemBrowserMapping(String userAgent, int profileId) {
        this.setUserBrowserMapping(this.getSystemUser(), userAgent, profileId);
    }

    private String getSystemBrowserMapping(String userAgent) {
        return this.getUserBrowserMapping(this.getSystemUser(), userAgent);
    }

    public IUserProfile getUserProfile(IPerson person, String userAgent) {
        String profileFname = this.getUserBrowserMapping(person, userAgent);
        if (profileFname == null) {
            return null;
        }
        return this.getUserProfileByFname(person, profileFname);
    }

    public IUserProfile getSystemProfile(String userAgent) {
        String profileFname = this.getSystemBrowserMapping(userAgent);
        if (profileFname == null) {
            return null;
        }
        UserProfile up = this.getUserProfileByFname(this.getSystemUser(), profileFname);
        up.setSystemProfile(true);
        return up;
    }

    public IUserProfile getSystemProfileById(int profileId) {
        IUserProfile up = this.getUserProfileById(this.getSystemUser(), profileId);
        up.setSystemProfile(true);
        return up;
    }

    public IUserProfile getSystemProfileByFname(String profileFname) {
        UserProfile up = this.getUserProfileByFname(this.getSystemUser(), profileFname);
        up.setSystemProfile(true);
        return up;
    }

    public Hashtable getSystemProfileList() {
        Hashtable pl = this.getUserProfileList(this.getSystemUser());
        Enumeration e = pl.elements();
        while (e.hasMoreElements()) {
            IUserProfile up = (IUserProfile)e.nextElement();
            up.setSystemProfile(true);
        }
        return pl;
    }

    public void updateSystemProfile(IUserProfile profile) {
        this.updateUserProfile(this.getSystemUser(), profile);
    }

    public IUserProfile addSystemProfile(IUserProfile profile) {
        return this.addUserProfile(this.getSystemUser(), profile);
    }

    public void deleteSystemProfile(int profileId) {
        this.deleteUserProfile(this.getSystemUser(), profileId);
    }

    protected int getLayoutID(int userId, int profileId) throws SQLException {
        return (Integer)this.jdbcOperations.execute((ConnectionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public abstract void importLayout(org.dom4j.Element var1);

    static /* synthetic */ int access$000(RDBMUserLayoutStore x0) {
        return x0.getNextKey();
    }

    static /* synthetic */ IPerson access$100(RDBMUserLayoutStore x0) {
        return x0.getSystemUser();
    }

    static /* synthetic */ ILocaleStore access$200(RDBMUserLayoutStore x0) {
        return x0.localeStore;
    }
}

