/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.logging;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.Validate;
import org.jasig.portal.logging.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
extends Writer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final StringBuilder builder = new StringBuilder();
    private final Logger logger;
    private final LogLevel appendLevel;

    public LoggingWriter(String loggerName, LogLevel appendLevel) {
        this(LoggerFactory.getLogger((String)loggerName), appendLevel);
    }

    public LoggingWriter(Class<?> clazz, LogLevel appendLevel) {
        this(LoggerFactory.getLogger(clazz), appendLevel);
    }

    public LoggingWriter(Logger logger, LogLevel appendLevel) {
        Validate.notNull((Object)logger);
        Validate.notNull((Object)appendLevel);
        this.logger = logger;
        this.appendLevel = appendLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIfNeeded() {
        while (this.builder.length() > 0) {
            StringBuilder stringBuilder = this.builder;
            synchronized (stringBuilder) {
                int newlineIndex = this.builder.indexOf(NEWLINE);
                if (newlineIndex < 0) {
                    return;
                }
                if (newlineIndex == 0) {
                    this.builder.delete(0, NEWLINE.length());
                    this.appendLevel.log(this.logger, "");
                }
                String msg = this.builder.substring(0, newlineIndex);
                this.builder.delete(0, newlineIndex + NEWLINE.length());
                this.appendLevel.log(this.logger, msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append((char)c);
        }
        this.logIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(cbuf);
        }
        this.logIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(str);
        }
        this.logIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(str);
        }
        this.logIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence csq) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(csq);
        }
        this.logIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(csq, start, end);
        }
        this.logIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer append(char c) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(c);
        }
        this.logIfNeeded();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            this.builder.append(cbuf, off, len);
        }
        this.logIfNeeded();
    }

    @Override
    public void flush() throws IOException {
        this.logIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        StringBuilder stringBuilder = this.builder;
        synchronized (stringBuilder) {
            if (this.builder.length() > 0 && this.builder.lastIndexOf(NEWLINE) < this.builder.length() - NEWLINE.length()) {
                this.builder.append(NEWLINE);
            }
            this.logIfNeeded();
        }
    }
}

