/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.permission.dao.jpa;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.jasig.portal.permission.IPermissionActivity;

@Entity
@Table(name="UP_PERMISSION_ACTIVITY")
@SequenceGenerator(name="UP_PERMISSION_ACTIVITY_GEN", sequenceName="UP_PERMISSION_ACTIVITY_SEQ", allocationSize=5)
@TableGenerator(name="UP_PERMISSION_ACTIVITY_GEN", pkColumnValue="UP_PERMISSION_ACTIVITY", allocationSize=5)
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
class PermissionActivityImpl
implements IPermissionActivity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UP_PERMISSION_ACTIVITY_GEN")
    @Column(name="ACTIVITY_ID")
    private final long id;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @Column(name="ACTIVITY_FNAME", length=128, nullable=false, unique=true)
    @Type(type="fname")
    private String fname;
    @Column(name="ACTIVITY_NAME", length=128, nullable=false, unique=true)
    private String name;
    @Column(name="ACTIVITY_DESCRIPTION", length=255)
    private String description;
    @Column(name="OWNER_TARGET_PROVIDER", length=255, nullable=false)
    private String targetProviderKey;

    private PermissionActivityImpl() {
        this.id = -1L;
        this.entityVersion = -1L;
    }

    public PermissionActivityImpl(String name, String fname, String targetProviderKey) {
        this.id = -1L;
        this.entityVersion = -1L;
        this.name = name;
        this.fname = fname;
        this.targetProviderKey = targetProviderKey;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTargetProviderKey() {
        return this.targetProviderKey;
    }

    public void setTargetProviderKey(String targetProviderKey) {
        this.targetProviderKey = targetProviderKey;
    }

    public Long getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IPermissionActivity)) {
            return false;
        }
        IPermissionActivity activity = (IPermissionActivity)obj;
        return this.fname.equals(activity);
    }

    public int hashCode() {
        return new HashCodeBuilder(464270933, -1074792143).append((Object)this.fname).toHashCode();
    }

    public String toString() {
        return "PermissionActivityImpl [id=" + this.id + ", entityVersion=" + this.entityVersion + ", fname=" + this.fname + ", name=" + this.name + ", description=" + this.description + ", targetProviderKey=" + this.targetProviderKey + "]";
    }

    public int compareTo(IPermissionActivity activity) {
        return new CompareToBuilder().append((Object)this.name, (Object)activity.getName()).append((Object)this.targetProviderKey, (Object)activity.getTargetProviderKey()).append((Object)this.fname, (Object)activity.getFname()).toComparison();
    }
}

