/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.permission.target;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.layout.dlm.remoting.IGroupListHelper;
import org.jasig.portal.layout.dlm.remoting.JsonEntityBean;
import org.jasig.portal.permission.target.IPermissionTarget;
import org.jasig.portal.permission.target.IPermissionTargetProvider;
import org.jasig.portal.permission.target.PermissionTargetImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityTargetProviderImpl
implements IPermissionTargetProvider,
Serializable {
    private Set<String> allowedEntityTypes = new HashSet();
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private transient IGroupListHelper groupListHelper;

    @Autowired(required=true)
    public void setGroupListHelper(IGroupListHelper helper) {
        this.groupListHelper = helper;
    }

    public EntityTargetProviderImpl(Set<String> allowedEntityTypes) {
        this.allowedEntityTypes = allowedEntityTypes;
    }

    public IPermissionTarget getTarget(String key) {
        if ("ALL_CATEGORIES".equals(key)) {
            return this.getAllCategoriesTarget();
        }
        if ("ALL_PORTLETS".equals(key)) {
            return this.getAllPortletsTarget();
        }
        if ("ALL_GROUPS".equals(key)) {
            return this.getAllGroupsTarget();
        }
        for (String type : this.allowedEntityTypes) {
            JsonEntityBean entity = this.groupListHelper.getEntity(type, key, false);
            if (entity == null) continue;
            String entityId = entity.getId();
            if ("portlet".equals(type)) {
                entityId = "PORTLET_ID.".concat(entityId);
            }
            PermissionTargetImpl target = new PermissionTargetImpl(entityId, entity.getName());
            return target;
        }
        return null;
    }

    public Collection<IPermissionTarget> searchTargets(String term) {
        HashSet<IPermissionTarget> matching = new HashSet<IPermissionTarget>();
        for (String type : this.allowedEntityTypes) {
            Set entities = this.groupListHelper.search(type, term);
            for (JsonEntityBean entity : entities) {
                PermissionTargetImpl target = new PermissionTargetImpl(entity.getId(), entity.getName());
                matching.add((IPermissionTarget)target);
            }
        }
        if ("ALL_CATEGORIES".contains(term)) {
            matching.add(this.getAllCategoriesTarget());
        } else if ("ALL_PORTLETS".contains(term)) {
            matching.add(this.getAllPortletsTarget());
        } else if ("ALL_GROUPS".contains(term)) {
            matching.add(this.getAllGroupsTarget());
        }
        return matching;
    }

    protected IPermissionTarget getAllCategoriesTarget() {
        return new PermissionTargetImpl("ALL_CATEGORIES", "ALL_CATEGORIES");
    }

    protected IPermissionTarget getAllGroupsTarget() {
        return new PermissionTargetImpl("ALL_GROUPS", "ALL_GROUPS");
    }

    protected IPermissionTarget getAllPortletsTarget() {
        return new PermissionTargetImpl("ALL_PORTLETS", "ALL_PORTLETS");
    }
}

