/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.persondir.dao.jpa;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.portal.jpa.BasePortalJpaDao;
import org.jasig.portal.persondir.ILocalAccountDao;
import org.jasig.portal.persondir.ILocalAccountPerson;
import org.jasig.portal.persondir.LocalAccountQuery;
import org.jasig.portal.persondir.dao.jpa.LocalAccountPersonAttributeImpl_;
import org.jasig.portal.persondir.dao.jpa.LocalAccountPersonImpl;
import org.jasig.portal.persondir.dao.jpa.LocalAccountPersonImpl_;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;

@Repository(value="localAccountDao")
public class JpaLocalAccountDaoImpl
extends BasePortalJpaDao
implements ILocalAccountDao {
    private CriteriaQuery<LocalAccountPersonImpl> findAllAccountsQuery;
    private CriteriaQuery<LocalAccountPersonImpl> findAccountByNameQuery;
    private CriteriaQuery<String> findAvailableAttributesQuery;
    private ParameterExpression<String> nameParameter;

    public void afterPropertiesSet() throws Exception {
        this.nameParameter = this.createParameterExpression(String.class, "name");
        this.findAllAccountsQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAccountByNameQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.findAvailableAttributesQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ILocalAccountPerson getPerson(long id) {
        return (ILocalAccountPerson)this.getEntityManager().find(LocalAccountPersonImpl.class, (Object)id);
    }

    @BasePortalJpaDao.PortalTransactional
    public ILocalAccountPerson createPerson(String username) {
        LocalAccountPersonImpl person = new LocalAccountPersonImpl(username);
        this.getEntityManager().persist((Object)person);
        return person;
    }

    public ILocalAccountPerson getPerson(String username) {
        TypedQuery query = this.createCachedQuery(this.findAccountByNameQuery);
        query.setParameter((Parameter)this.nameParameter, (Object)username);
        List accounts = query.getResultList();
        return (ILocalAccountPerson)DataAccessUtils.uniqueResult((Collection)accounts);
    }

    public List<ILocalAccountPerson> getAllAccounts() {
        TypedQuery query = this.createCachedQuery(this.findAllAccountsQuery);
        List accounts = query.getResultList();
        return new ArrayList<ILocalAccountPerson>(accounts);
    }

    @BasePortalJpaDao.PortalTransactional
    public ILocalAccountPerson updateAccount(ILocalAccountPerson account) {
        Validate.notNull((Object)account, (String)"account can not be null");
        this.getEntityManager().persist((Object)account);
        return account;
    }

    @BasePortalJpaDao.PortalTransactional
    public void deleteAccount(ILocalAccountPerson account) {
        Validate.notNull((Object)account, (String)"definition can not be null");
        EntityManager entityManager = this.getEntityManager();
        ILocalAccountPerson persistentAccount = entityManager.contains((Object)account) ? account : (ILocalAccountPerson)entityManager.merge((Object)account);
        entityManager.remove((Object)persistentAccount);
    }

    public List<ILocalAccountPerson> getPeople(LocalAccountQuery query) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder cb = entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(LocalAccountPersonImpl.class);
        Root accountRoot = criteriaQuery.from(LocalAccountPersonImpl.class);
        CollectionJoin attributes = accountRoot.join(LocalAccountPersonImpl_.attributes);
        ListJoin attributeValues = attributes.join(LocalAccountPersonAttributeImpl_.values);
        criteriaQuery.distinct(true);
        criteriaQuery.select((Selection)accountRoot);
        LinkedList<Predicate> whereParts = new LinkedList<Predicate>();
        LinkedHashMap<ParameterExpression, String> params = new LinkedHashMap<ParameterExpression, String>();
        if (query.getName() != null) {
            whereParts.add(cb.equal((Expression)accountRoot.get(LocalAccountPersonImpl_.name), (Expression)this.nameParameter));
            params.put(this.nameParameter, query.getName());
        }
        int paramCount = 0;
        for (Map.Entry entry : query.getAttributes().entrySet()) {
            List values = (List)entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                if (StringUtils.isBlank((String)value)) continue;
                ParameterExpression nameParam = this.createParameterExpression(String.class, "attrName" + paramCount);
                ParameterExpression valueParam = this.createParameterExpression(String.class, "attrValue" + paramCount);
                params.put(nameParam, (String)entry.getKey());
                params.put(valueParam, "%" + value.toLowerCase() + "%");
                whereParts.add(cb.and((Expression)cb.equal((Expression)attributes.get(LocalAccountPersonAttributeImpl_.name), (Expression)nameParam), (Expression)cb.like(cb.lower(attributeValues.as(String.class)), (Expression)valueParam)));
                ++paramCount;
            }
        }
        criteriaQuery.where((Expression)cb.or(whereParts.toArray(new Predicate[whereParts.size()])));
        TypedQuery jpaQuery = this.createCachedQuery(criteriaQuery);
        for (Map.Entry entry : params.entrySet()) {
            String value;
            Parameter parameter = (Parameter)entry.getKey();
            value = (String)entry.getValue();
            jpaQuery.setParameter(parameter, (Object)value);
        }
        List accounts = jpaQuery.getResultList();
        return new ArrayList<ILocalAccountPerson>(accounts);
    }

    public Set<String> getCurrentAttributeNames() {
        TypedQuery query = this.createCachedQuery(this.findAvailableAttributesQuery);
        List nameList = query.getResultList();
        return new LinkedHashSet<String>(nameList);
    }

    static /* synthetic */ ParameterExpression access$000(JpaLocalAccountDaoImpl x0) {
        return x0.nameParameter;
    }
}

