/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.jasig.portal.portlet.rendering.IPortletRenderer;

public final class PortletUtils {
    private static final Map<String, PortletMode> PORTLET_MODES = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)PortletMode.VIEW.toString(), (Object)PortletMode.VIEW).put((Object)PortletMode.EDIT.toString(), (Object)PortletMode.EDIT).put((Object)PortletMode.HELP.toString(), (Object)PortletMode.HELP).put((Object)IPortletRenderer.ABOUT.toString(), (Object)IPortletRenderer.ABOUT).put((Object)IPortletRenderer.CONFIG.toString(), (Object)IPortletRenderer.CONFIG).build();
    private static final Map<String, WindowState> WINDOW_STATES = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)WindowState.NORMAL.toString(), (Object)WindowState.NORMAL).put((Object)WindowState.MAXIMIZED.toString(), (Object)WindowState.MAXIMIZED).put((Object)WindowState.MINIMIZED.toString(), (Object)WindowState.MINIMIZED).put((Object)IPortletRenderer.DASHBOARD.toString(), (Object)IPortletRenderer.DASHBOARD).put((Object)IPortletRenderer.DETACHED.toString(), (Object)IPortletRenderer.DETACHED).put((Object)IPortletRenderer.EXCLUSIVE.toString(), (Object)IPortletRenderer.EXCLUSIVE).build();
    private static final Set<WindowState> TARGETED_WINDOW_STATES = ImmutableSet.builder().add((Object)WindowState.MAXIMIZED).add((Object)IPortletRenderer.DETACHED).add((Object)IPortletRenderer.EXCLUSIVE).build();

    private PortletUtils() {
    }

    public static boolean isTargetedWindowState(WindowState state) {
        return TARGETED_WINDOW_STATES.contains(state);
    }

    public static PortletMode getPortletMode(String mode) {
        if (mode == null) {
            return null;
        }
        PortletMode portletMode = (PortletMode)PORTLET_MODES.get(mode);
        if (portletMode != null) {
            return portletMode;
        }
        return new PortletMode(mode);
    }

    public static WindowState getWindowState(String state) {
        if (state == null) {
            return null;
        }
        WindowState windowState = (WindowState)WINDOW_STATES.get(state);
        if (windowState != null) {
            return windowState;
        }
        return new WindowState(state);
    }
}

