/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.container.EventProvider;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PortletContextService;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.jasig.portal.portlet.container.EventImpl;
import org.jasig.portal.portlet.om.IPortletWindow;

public class EventProviderImpl
implements EventProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final IPortletWindow portletWindow;
    private final ClassLoader portletClassLoader;

    public EventProviderImpl(IPortletWindow portletWindow, PortletContextService portletContextService) {
        this.portletWindow = portletWindow;
        PortletDefinition portletDefinition = portletWindow.getPlutoPortletWindow().getPortletDefinition();
        PortletApplicationDefinition application = portletDefinition.getApplication();
        String portletApplicationName = application.getName();
        try {
            this.portletClassLoader = portletContextService.getClassLoader(portletApplicationName);
        }
        catch (PortletContainerException e) {
            throw new IllegalStateException("Failed to find ClassLoader for portlet applicaiton: " + portletApplicationName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event createEvent(QName qname, Serializable value) throws IllegalArgumentException {
        if (this.isDeclaredAsPublishingEvent(qname)) {
            if (value != null && !this.isValueInstanceOfDefinedClass(qname, value)) {
                throw new IllegalArgumentException("Payload class (" + value.getClass().getCanonicalName() + ") does not have the right class, check your defined event types in portlet.xml.");
            }
            if (value == null) {
                return new EventImpl(qname);
            }
            try {
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                StringWriter out = new StringWriter();
                Class<?> clazz = value.getClass();
                try {
                    currentThread.setContextClassLoader(this.portletClassLoader);
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Marshaller marshaller = jc.createMarshaller();
                    JAXBElement element = new JAXBElement(qname, clazz, (Object)value);
                    marshaller.marshal((Object)element, (Writer)out);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                return new EventImpl(qname, (Serializable)((Object)((Object)out).toString()));
            }
            catch (JAXBException e) {
                this.logger.error((Object)"Event handling failed", (Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isDeclaredAsPublishingEvent(QName qname) {
        PortletDefinition portletDescriptor = this.portletWindow.getPlutoPortletWindow().getPortletDefinition();
        List events = portletDescriptor.getSupportedPublishingEvents();
        if (events == null) {
            return false;
        }
        PortletApplicationDefinition application = portletDescriptor.getApplication();
        String defaultNamespace = application.getDefaultNamespace();
        for (EventDefinitionReference ref : events) {
            QName name = ref.getQualifiedName(defaultNamespace);
            if (name == null || !qname.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isValueInstanceOfDefinedClass(QName qname, Serializable value) {
        PortletDefinition portletDefinition = this.portletWindow.getPlutoPortletWindow().getPortletDefinition();
        PortletApplicationDefinition app = portletDefinition.getApplication();
        List events = app.getEventDefinitions();
        if (events == null) {
            return true;
        }
        String defaultNamespace = app.getDefaultNamespace();
        for (EventDefinition eventDefinition : events) {
            if (eventDefinition.getQName() != null) {
                if (!eventDefinition.getQName().equals(qname)) continue;
                Class<?> valueClass = value.getClass();
                return valueClass.getName().equals(eventDefinition.getValueType());
            }
            QName tmp = new QName(defaultNamespace, eventDefinition.getName());
            if (!tmp.equals(qname)) continue;
            Class<?> valueClass = value.getClass();
            return valueClass.getName().equals(eventDefinition.getValueType());
        }
        return true;
    }
}

