/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.portlet.container;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.jasig.portal.portlet.container.PortletResponseContextImpl;
import org.jasig.portal.portlet.container.properties.IRequestPropertiesManager;
import org.jasig.portal.portlet.container.services.IPortletCookieService;
import org.jasig.portal.portlet.om.IPortletWindow;
import org.jasig.portal.portlet.om.IPortletWindowId;
import org.jasig.portal.portlet.rendering.IPortletRenderer;
import org.jasig.portal.portlet.rendering.PortletOutputHandler;
import org.jasig.portal.portlet.url.PortletURLProviderImpl;
import org.jasig.portal.url.IPortalUrlBuilder;
import org.jasig.portal.url.IPortalUrlProvider;
import org.jasig.portal.url.IPortletUrlBuilder;
import org.jasig.portal.url.UrlType;

public abstract class PortletMimeResponseContextImpl
extends PortletResponseContextImpl
implements PortletMimeResponseContext {
    private final IPortalUrlProvider portalUrlProvider;
    private final PortletOutputHandler portletOutputHandler;
    private final CacheControl cacheControl;

    public PortletMimeResponseContextImpl(PortletContainer portletContainer, IPortletWindow portletWindow, HttpServletRequest containerRequest, HttpServletResponse containerResponse, IRequestPropertiesManager requestPropertiesManager, IPortalUrlProvider portalUrlProvider, IPortletCookieService portletCookieService) {
        super(portletContainer, portletWindow, containerRequest, containerResponse, requestPropertiesManager, portletCookieService);
        Validate.notNull((Object)portalUrlProvider, (String)"portalUrlProvider can not be null");
        this.portalUrlProvider = portalUrlProvider;
        this.portletOutputHandler = (PortletOutputHandler)containerRequest.getAttribute(IPortletRenderer.ATTRIBUTE__PORTLET_OUTPUT_HANDLER);
        Validate.notNull((Object)this.portletOutputHandler, (String)("No " + IPortletRenderer.ATTRIBUTE__PORTLET_OUTPUT_HANDLER + " attribute found in request"));
        this.cacheControl = (CacheControl)containerRequest.getAttribute(IPortletRenderer.ATTRIBUTE__PORTLET_CACHE_CONTROL);
        Validate.notNull((Object)this.cacheControl, (String)("No " + IPortletRenderer.ATTRIBUTE__PORTLET_OUTPUT_HANDLER + " attribute found in request"));
    }

    protected final PortletOutputHandler getPortletOutputHandler() {
        return this.portletOutputHandler;
    }

    public CacheControl getCacheControl() {
        this.checkContextStatus();
        return this.cacheControl;
    }

    public void flushBuffer() throws IOException {
        this.checkContextStatus();
        this.portletOutputHandler.flushBuffer();
    }

    public int getBufferSize() {
        return this.portletOutputHandler.getBufferSize();
    }

    public String getCharacterEncoding() {
        this.checkContextStatus();
        return this.servletResponse.getCharacterEncoding();
    }

    public String getContentType() {
        this.checkContextStatus();
        return this.servletResponse.getContentType();
    }

    public Locale getLocale() {
        this.checkContextStatus();
        return this.servletResponse.getLocale();
    }

    public OutputStream getOutputStream() throws IOException, IllegalStateException {
        this.checkContextStatus();
        return this.portletOutputHandler.getOutputStream();
    }

    public PortletURLProvider getPortletURLProvider(PortletURLProvider.TYPE type) {
        IPortletWindowId portletWindowId = this.portletWindow.getPortletWindowId();
        UrlType urlType = UrlType.fromPortletUrlType((PortletURLProvider.TYPE)type);
        IPortalUrlBuilder portalUrlBuilder = this.portalUrlProvider.getPortalUrlBuilderByPortletWindow(this.containerRequest, portletWindowId, urlType);
        IPortletUrlBuilder portletUrlBuilder = portalUrlBuilder.getPortletUrlBuilder(portletWindowId);
        return new PortletURLProviderImpl(portletUrlBuilder);
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        this.checkContextStatus();
        return this.portletOutputHandler.getPrintWriter();
    }

    public boolean isCommitted() {
        return this.portletOutputHandler.isCommitted();
    }

    public void reset() {
        this.checkContextStatus();
        this.portletOutputHandler.reset();
    }

    public void resetBuffer() {
        this.checkContextStatus();
        this.portletOutputHandler.resetBuffer();
    }

    public void setBufferSize(int size) {
        this.checkContextStatus();
        this.portletOutputHandler.setBufferSize(size);
    }

    public void setContentType(String contentType) {
        this.checkContextStatus();
        this.portletOutputHandler.setContentType(contentType);
    }
}

